/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.util;

import com.objectriver.runtime.util.ArrayIterator;
import com.objectriver.runtime.util.StringUtility;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class FileHelper {
    public static File[] toFiles(File parent, String[] arrayOfFilenames) {
        File[] files = new File[arrayOfFilenames.length];
        for (int ii = 0; ii < arrayOfFilenames.length; ++ii) {
            files[ii] = new File(parent, arrayOfFilenames[ii]);
        }
        return files;
    }

    public static File[] toFiles(String[] arrayOfFilenames) {
        File[] files = new File[arrayOfFilenames.length];
        for (int ii = 0; ii < arrayOfFilenames.length; ++ii) {
            files[ii] = new File(arrayOfFilenames[ii]);
        }
        return files;
    }

    public static File toFile(File parent, File child) {
        return new File(parent, child.getName());
    }

    public static File toFile(File parent, String child) {
        return new File(parent, child);
    }

    public static String getBasename(File file) {
        String name = file.getName();
        int dot = name.lastIndexOf(46);
        if (dot > 0) {
            return name.substring(0, dot);
        }
        return name;
    }

    public static String getExtension(File file) {
        String name = file.getName();
        int dot = name.lastIndexOf(46);
        if (dot > 0) {
            return name.substring(dot + 1);
        }
        return null;
    }

    public static void touch(File file, boolean readonly) throws IOException {
        if (!file.exists()) {
            File parent = new File(file.getParent());
            if (!parent.exists()) {
                parent.mkdirs();
            }
            if (!file.createNewFile()) {
                throw new IOException("Failed to create file " + file.getPath());
            }
        }
        if (readonly && !file.setReadOnly()) {
            throw new IOException("Failed to setReadonly " + file.getPath());
        }
    }

    public static File getCaseInsensitiveFile(File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        String name = file.getName();
        File directory = FileHelper.getParentFile(file);
        if (directory.exists() && directory.isDirectory()) {
            File[] files = directory.listFiles();
            for (int ii = 0; ii < files.length; ++ii) {
                String goodCase = files[ii].getName();
                if (!goodCase.equalsIgnoreCase(name)) continue;
                return files[ii];
            }
        }
        return null;
    }

    public static File getParentFile(File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        File directory = file.getParentFile();
        if (directory == null) {
            try {
                File connoical = file.getCanonicalFile();
                directory = connoical.getParentFile();
            }
            catch (IOException io) {
                directory = new File(".");
            }
        }
        return directory;
    }

    public static File getSrcDir(File outDir) {
        try {
            String[] list = new String[]{"src", "SRC", "source", "SOURCE", "java", "JAVA"};
            File tmp = outDir.getCanonicalFile();
            String leafdir = tmp.getName();
            if (StringUtility.isListed(list, leafdir)) {
                return tmp;
            }
            File srcDir = null;
            while ((tmp = tmp.getParentFile()) != null) {
                String dirName = tmp.getName();
                if (!StringUtility.isListed(list, dirName)) continue;
                srcDir = tmp;
                return srcDir;
            }
            ArrayIterator iter = new ArrayIterator(outDir.list());
            while (iter.hasNext()) {
                String file = (String)iter.next();
                if (!StringUtility.isListed(list, file)) continue;
                srcDir = FileHelper.toFile(outDir, file);
                return srcDir;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return FileHelper.toFile(outDir, "src");
    }
}

