/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.util;

import com.objectriver.runtime.util.SimpleStringCipherException;
import java.security.InvalidKeyException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class SimpleStringCipher {
    private static String secret = "P1ckl3D0gFr3d$!%";
    private static SecretKey key;
    private static Cipher cipher;

    public static synchronized String encrypt(String plainText) throws SimpleStringCipherException {
        byte[] cipherText;
        try {
            cipher.init(1, key);
            cipherText = cipher.doFinal(plainText.getBytes());
        }
        catch (InvalidKeyException e) {
            throw new SimpleStringCipherException(e.getMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new SimpleStringCipherException(e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            throw new SimpleStringCipherException(e.getMessage(), e);
        }
        String encrypted = Base64.getEncoder().encodeToString(cipherText);
        return encrypted;
    }

    public static synchronized String decrypt(String codedText) throws SimpleStringCipherException {
        byte[] decrypted;
        try {
            byte[] encypted = Base64.getDecoder().decode(codedText.getBytes());
            cipher.init(2, key);
            decrypted = cipher.doFinal(encypted);
        }
        catch (InvalidKeyException e) {
            throw new SimpleStringCipherException(e.getMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new SimpleStringCipherException(e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            throw new SimpleStringCipherException(e.getMessage(), e);
        }
        return new String(decrypted);
    }

    public static void main(String[] args) {
        String plaintext = "The cow jumped over the moon";
        try {
            String encrypted = SimpleStringCipher.encrypt(plaintext);
            String decrypted = SimpleStringCipher.decrypt(encrypted);
            if (decrypted.equals(plaintext)) {
                System.out.println("It worked");
            } else {
                System.out.println(plaintext + " does not equal " + decrypted);
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getClass().toString() + ":" + ex.getMessage());
        }
    }

    static {
        try {
            key = new SecretKeySpec(secret.getBytes(), "AES");
            cipher = Cipher.getInstance("AES/ECB/PKCS5Padding", "SunJCE");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

