/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.util;

import java.io.IOException;
import java.io.Reader;

public class StringUtility {
    public static final String truncate(String str, int length) {
        if (str.length() > length) {
            return str.substring(0, length);
        }
        return str;
    }

    public static final boolean startsWithIgnoreCase(String prefix, String target) {
        if (target.length() < prefix.length()) {
            return false;
        }
        String beginning = target.substring(0, prefix.length());
        return beginning.equalsIgnoreCase(prefix);
    }

    public static final String pad(String str, char pad, int length) {
        int strlen = str.length();
        if (strlen < length) {
            int howmany = length - strlen;
            StringBuffer buffer = new StringBuffer(length).append(str);
            for (int ii = 0; ii < howmany; ++ii) {
                buffer.append(pad);
            }
            return buffer.toString();
        }
        return str;
    }

    public static final boolean isInteger(String str) {
        int len = str.length();
        if (len == 0) {
            return false;
        }
        int ii = 0;
        if (str.charAt(0) == '-' || str.charAt(0) == '+') {
            ++ii;
        }
        while (ii < len) {
            if (!Character.isDigit(str.charAt(ii))) {
                return false;
            }
            ++ii;
        }
        return true;
    }

    public static final boolean isFloating(String str) {
        int len = str.length();
        if (len == 0) {
            return false;
        }
        int ii = 0;
        if (str.charAt(0) == '-' || str.charAt(0) == '+') {
            ++ii;
        }
        while (ii < len) {
            if (!Character.isDigit(str.charAt(ii)) && str.charAt(ii) != '.') {
                return false;
            }
            ++ii;
        }
        return true;
    }

    public static String stringQuoter(String str) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (length == 0) {
            return "\"\"";
        }
        if (str.indexOf(34) < 0 && str.indexOf(92) < 0) {
            return new StringBuffer(length + 2).append('\"').append(str).append('\"').toString();
        }
        char[] chars = str.toCharArray();
        int len = chars.length;
        StringBuffer newchars = new StringBuffer(len + 100);
        newchars.append('\"');
        for (int ii = 0; ii < len; ++ii) {
            if (chars[ii] == '\"' || chars[ii] == '\\') {
                newchars.append('\\');
            }
            newchars.append(chars[ii]);
        }
        newchars.append('\"');
        return newchars.toString();
    }

    public static String removeQuotes(String str) {
        if (str == null) {
            return str;
        }
        if (str.length() == 0) {
            return str;
        }
        if (str.charAt(0) == '\"' || str.charAt(0) == '\'') {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static boolean isListed(String[] list, String value) {
        for (int ii = 0; ii < list.length; ++ii) {
            if (!list[ii].equals(value)) continue;
            return true;
        }
        return false;
    }

    public static String stripTrailingWhiteSpace(String str) {
        int len = str.length();
        if (len == 0) {
            return str;
        }
        char lastchar = str.charAt(len - 1);
        if (Character.isWhitespace(lastchar) || lastchar == '\n') {
            for (int ii = len - 1; ii > 0; --ii) {
                lastchar = str.charAt(ii - 1);
                if (Character.isWhitespace(lastchar) || lastchar == '\n') continue;
                return str.substring(0, ii);
            }
        }
        return str;
    }

    public static String stripWhite(String str) {
        int len = str.length();
        if (len == 0) {
            return str;
        }
        StringBuffer buff = new StringBuffer(len);
        for (int ii = 0; ii < len; ++ii) {
            char character = str.charAt(ii);
            if (Character.isWhitespace(character) || character == '\n') continue;
            buff.append(character);
        }
        return buff.toString();
    }

    public static String fromReader(Reader is) throws IOException {
        int n;
        int BLKSIZ = 8192;
        char[] b = new char[8192];
        StringBuffer buffer = new StringBuffer(8192);
        while ((n = is.read(b)) > 0) {
            buffer.append(b, 0, n);
        }
        return buffer.toString();
    }
}

