/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.util.metadata;

import com.objectriver.runtime.primitives.StringConst;
import com.objectriver.runtime.util.asserts.Assert;
import com.objectriver.runtime.util.metadata.MetadataSingleton;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Metadata {
    private final String name;
    private Class clazz;

    public Metadata(String persistentName) throws ClassNotFoundException {
        Class<?> interfaceclass = null;
        this.name = persistentName;
        String interfaceClassName = "primitives." + persistentName + "Persistent";
        interfaceclass = Class.forName(interfaceClassName);
        if (interfaceclass != null) {
            MetadataSingleton.addPersistentClass(interfaceclass);
        }
        try {
            Field field = interfaceclass.getField("packageName");
            String packageName = (String)field.get(null);
            String persistentClassName = "objects." + packageName + "." + persistentName;
            this.clazz = Class.forName(persistentClassName);
        }
        catch (NoSuchFieldException e) {
            String persistentClassName = "objects." + persistentName.toLowerCase() + "." + persistentName;
            this.clazz = Class.forName(persistentClassName);
        }
        catch (IllegalAccessException e) {
            Assert.fail("Internal Error");
        }
    }

    public Metadata(Class clazz, String persistentName) throws ClassNotFoundException {
        this(Metadata.extractName(clazz));
    }

    public Metadata(Class clazz) throws ClassNotFoundException {
        this(Metadata.extractName(clazz));
    }

    private static String extractName(Class clazz) {
        Pattern pattern = Pattern.compile("[^.]+$");
        Matcher matcher = pattern.matcher(clazz.getName());
        String pname = clazz.getName();
        if (matcher.find()) {
            pname = matcher.group();
        }
        return pname;
    }

    public String getName() {
        return this.name;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public static String[] getPersistentNames() {
        MetadataSingleton mSingleton = MetadataSingleton.getInstance();
        int number = mSingleton.getNumber();
        if (number == 0) {
            return StringConst.emptyStringArray;
        }
        Iterator iter = mSingleton.iterator();
        String[] persistentNames = new String[number];
        for (int ii = 0; ii < number && iter.hasNext(); ++ii) {
            persistentNames[ii] = (String)iter.next();
        }
        return persistentNames;
    }

    public String[] getPersistentKeyNames() {
        try {
            String oidClassName = "things." + this.name + "Oid";
            Class<?> clazz = Class.forName(oidClassName);
            Field[] fields = clazz.getFields();
            String[] keyNames = new String[fields.length];
            for (int ii = 0; ii < fields.length; ++ii) {
                keyNames[ii] = fields[ii].getName();
            }
            return keyNames;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return StringConst.emptyStringArray;
        }
    }

    public String[] getComponentNames() {
        try {
            return this.getEnumerationMenu("things." + this.name + "ComponentEnum");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return StringConst.emptyStringArray;
        }
    }

    public String[] getFieldNames(String componentName) {
        try {
            return this.getEnumerationMenu("rows." + componentName + "FieldEnum");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return StringConst.emptyStringArray;
        }
    }

    private String[] getEnumerationMenu(String aenum) throws ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName(aenum);
            Method method = clazz.getMethod("getMenu", new Class[0]);
            String[] menu = (String[])method.invoke(null, new Object[0]);
            return menu;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return StringConst.emptyStringArray;
    }

    public static void main(String[] args) {
        try {
            Metadata metadata = new Metadata(args[0]);
            System.out.println("Persistent Class = " + args[0]);
            String[] keys = metadata.getPersistentKeyNames();
            Assert.assertTrue("getFieldNames() failed.", keys.length > 0);
            for (int jj = 0; jj < keys.length; ++jj) {
                System.out.println("\tKey = " + keys[jj]);
            }
            String[] components = metadata.getComponentNames();
            Assert.assertTrue("getComponentNames() failed.", components.length > 0);
            for (int ii = 0; ii < components.length; ++ii) {
                System.out.println("\tComponent = " + components[ii]);
                String[] fields = metadata.getFieldNames(components[ii]);
                Assert.assertTrue("getFieldNames() failed.", fields.length > 0);
                for (int jj = 0; jj < fields.length; ++jj) {
                    System.out.println("\t\tField = " + fields[jj]);
                }
            }
            System.out.println("Thats all!");
        }
        catch (ClassNotFoundException e) {
            Assert.fail(args[0] + " Jar file not loaded?");
        }
    }

    public String getRootTableName() {
        String[] menu = this.getComponentNames();
        if (menu == StringConst.emptyStringArray) {
            return this.name;
        }
        return menu[0];
    }
}

