/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.util.resource;

import com.objectriver.runtime.util.ArrayIterator;
import com.objectriver.runtime.util.FileHelper;
import com.objectriver.runtime.util.asserts.Assert;
import com.objectriver.runtime.util.resource.Resource;
import com.objectriver.runtime.util.resource.ResourceType;
import com.objectriver.runtime.util.resource.UrlHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;

public class FileResource
implements Resource {
    private final ResourceType type;
    private File resource;
    private URL url;
    private Reader reader = null;

    public FileResource(URL url) {
        this.url = url;
        this.resource = new File(url.getFile());
        this.type = ResourceType.File;
    }

    public FileResource(File file) {
        try {
            this.url = new URL("file", null, UrlHelper.escape(file.getAbsolutePath()));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            Assert.fail("Internal Error");
        }
        this.resource = file.isAbsolute() ? file : file.getAbsoluteFile();
        this.type = ResourceType.File;
    }

    @Override
    public ResourceType getType() {
        return this.type;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public String getName() {
        String name = this.url.toString();
        int begin = name.lastIndexOf(File.separatorChar);
        return name.substring(begin + 1);
    }

    @Override
    public String getPath() {
        return this.url.toString();
    }

    @Override
    public Resource addToPath(String member) {
        return new FileResource(FileHelper.toFile(this.resource, member));
    }

    @Override
    public boolean canRead() {
        return this.resource.canRead();
    }

    @Override
    public boolean memberExists(String member) {
        Assert.assertTrue("Resource must be directory", this.isDirectory());
        File file = new File(this.resource, member);
        return file.exists();
    }

    @Override
    public Resource getMember(String member) {
        Assert.assertTrue("Resource must be directory", this.isDirectory());
        File file = new File(this.resource, member);
        if (file.exists()) {
            return new FileResource(file);
        }
        return null;
    }

    @Override
    public Resource getMember(String path, String member) {
        Assert.assertTrue("Resource must be directory", this.isDirectory());
        File file = new File(this.resource, member);
        if (file.exists()) {
            return new FileResource(file);
        }
        File file2 = new File(this.resource, path + "/" + member);
        if (file2.exists()) {
            return new FileResource(file2);
        }
        return null;
    }

    @Override
    public Iterator iterateMembers() {
        File[] members = this.resource.listFiles();
        LinkedList<FileResource> resourcemembers = new LinkedList<FileResource>();
        for (int ii = 0; ii < members.length; ++ii) {
            resourcemembers.add(new FileResource(members[ii]));
        }
        return new ArrayIterator(resourcemembers.toArray());
    }

    @Override
    public Resource getParent() {
        FileResource parent = null;
        Assert.assertTrue("File doe's not exist?" + this.resource.getPath(), this.resource.exists());
        try {
            parent = new FileResource(FileHelper.getParentFile(this.resource));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return parent;
    }

    @Override
    public boolean exists() {
        return this.resource.exists();
    }

    @Override
    public boolean isDirectory() {
        return this.resource.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.resource.isFile();
    }

    @Override
    public Reader getReader() throws IOException {
        if (this.reader == null) {
            return new FileReader(this.resource);
        }
        return this.reader;
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public BufferedReader getBufferedReader() throws IOException {
        return new BufferedReader(this.getReader());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.resource);
    }

    @Override
    public String toString() {
        return this.getPath();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FileResource)) {
            return false;
        }
        FileResource resource = (FileResource)obj;
        return this.url.equals(resource.getURL());
    }

    public int hashCode() {
        return this.url.hashCode();
    }
}

