/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.util.resource;

import com.objectriver.runtime.util.asserts.Assert;
import com.objectriver.runtime.util.resource.Resource;
import com.objectriver.runtime.util.resource.ResourceType;
import com.objectriver.runtime.util.resource.UrlHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarResource
implements Resource {
    private JarURLConnection jarConn;
    private JarFile jarFile;
    private JarEntry jarEntry;
    private URL url;
    private final ResourceType type;
    private Reader reader = null;

    public JarResource(URL url) {
        this.url = url;
        this.type = ResourceType.Jar;
        String string = url.toString();
        Assert.assertTrue("Invalid URL for Jar: " + string, string.startsWith("jar:"));
        try {
            this.jarConn = (JarURLConnection)url.openConnection();
            this.jarFile = this.jarConn.getJarFile();
            this.jarEntry = this.jarConn.getJarEntry();
        }
        catch (IOException e) {
            Assert.fail("Bad URL resource: " + string);
        }
    }

    public JarResource(JarFile jarFile) {
        this.type = ResourceType.Jar;
        this.jarFile = jarFile;
        this.jarEntry = new JarEntry("/");
        String name = "jar:file:" + jarFile.getName() + "!" + this.jarEntry.getName();
        try {
            this.url = new URL(UrlHelper.escape(name));
            this.jarConn = (JarURLConnection)this.url.openConnection();
        }
        catch (MalformedURLException e) {
            Assert.fail("Internal Error");
        }
        catch (IOException e) {
            Assert.fail("Internal Error");
        }
    }

    public JarResource(JarFile jarFile, JarEntry entry) {
        this.type = ResourceType.Jar;
        this.jarFile = jarFile;
        this.jarEntry = entry;
        String name = "jar:file:" + jarFile.getName() + "!/" + this.jarEntry.getName();
        try {
            this.url = new URL(UrlHelper.escape(name));
            this.jarConn = (JarURLConnection)this.url.openConnection();
        }
        catch (MalformedURLException e) {
            Assert.fail("Internal Error");
        }
        catch (IOException e) {
            Assert.fail("Internal Error");
        }
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public ResourceType getType() {
        return this.type;
    }

    @Override
    public String getName() {
        String name = this.url.toString();
        int begin = name.lastIndexOf(47);
        return name.substring(begin + 1);
    }

    @Override
    public String getPath() {
        return this.url.toString();
    }

    @Override
    public Resource addToPath(String member) {
        String entry = this.jarEntry.getName();
        if (!entry.endsWith("/") && !entry.endsWith("\\")) {
            entry = entry + "/";
        }
        return new JarResource(this.jarFile, new JarEntry(entry + member));
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean memberExists(String member) {
        Assert.assertTrue("Initial member does not exist!", this.jarEntry != null);
        Assert.assertTrue("Resource must be directory", this.jarEntry.isDirectory());
        JarEntry entry = this.getEntry(member);
        return entry != null;
    }

    @Override
    public Resource getMember(String member) {
        Assert.assertTrue("Initial member does not exist!", this.jarEntry != null);
        Assert.assertTrue("Resource must be directory", this.isDirectory());
        JarEntry entry = this.getEntry(member);
        if (entry == null) {
            return null;
        }
        return new JarResource(this.createNewUrl(entry));
    }

    @Override
    public Resource getMember(String path, String member) {
        Assert.assertTrue("Initial member does not exist!", this.jarEntry != null);
        Assert.assertTrue("Resource must be directory", this.isDirectory());
        JarEntry entry = this.getEntry(member);
        if (entry != null) {
            return new JarResource(this.createNewUrl(entry));
        }
        entry = this.getEntry(path + "/" + member);
        if (entry != null) {
            return new JarResource(this.createNewUrl(entry));
        }
        return null;
    }

    @Override
    public Iterator iterateMembers() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource getParent() {
        try {
            int bang;
            int end;
            StringBuffer buff = new StringBuffer(this.url.toString());
            if (buff.toString().endsWith("/")) {
                buff.deleteCharAt(buff.length() - 1);
            }
            if ((end = buff.lastIndexOf("/")) >= (bang = buff.indexOf("!"))) {
                return new JarResource(new URL(buff.substring(0, end)));
            }
            Assert.fail("Internal Error");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            Assert.fail("Internal Error");
        }
        return null;
    }

    private JarEntry getEntry(String member) {
        StringBuffer newEntry = new StringBuffer(100).append(this.jarConn.getEntryName());
        if (!newEntry.toString().endsWith("/")) {
            newEntry.append('/');
        }
        newEntry.append(member);
        JarEntry entry = this.jarFile.getJarEntry(newEntry.toString());
        return entry;
    }

    private URL createNewUrl(JarEntry jarEntry) {
        URL newUrl = null;
        String buff = this.url.toString();
        int bang = buff.indexOf(33);
        Assert.assertTrue("Invalid URL" + this.url.toString(), bang > 0);
        String urlString = buff.substring(0, bang + 1) + "/" + jarEntry.getName();
        try {
            newUrl = new URL(urlString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newUrl;
    }

    @Override
    public boolean exists() {
        return this.jarEntry != null;
    }

    @Override
    public boolean isDirectory() {
        Assert.assertTrue("Initial member does not exist!", this.jarEntry != null);
        String entry = this.jarConn.getEntryName();
        if (entry.endsWith("/")) {
            return true;
        }
        int dot = entry.indexOf(46);
        return dot == -1;
    }

    @Override
    public boolean isFile() {
        Assert.assertTrue("Initial member does not exist!", this.jarEntry != null);
        return !this.jarEntry.isDirectory();
    }

    @Override
    public Reader getReader() throws IOException {
        Assert.assertTrue("Initial member does not exist!", this.jarEntry != null);
        Assert.assertTrue("JarEntry must file!", this.isFile());
        if (this.reader == null) {
            InputStream inputStream = this.jarConn.getInputStream();
            return new InputStreamReader(inputStream);
        }
        return this.reader;
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public BufferedReader getBufferedReader() throws IOException {
        return new BufferedReader(this.getReader());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.jarConn.getInputStream();
    }

    public static void main(String[] args) {
        try {
            URL url = new URL(args[0]);
            JarResource resource = new JarResource(url);
            System.out.println("Jar resource=" + args[0]);
            if (resource.exists()) {
                System.out.println("Jar resource exists.");
                if (resource.isDirectory()) {
                    System.out.println("Jar resource is directory");
                    if (resource.memberExists("runtime.mdl")) {
                        System.out.println("runtime.mdl exists");
                        Resource resource2 = resource.getMember("runtime.mdl");
                        BufferedReader reader = resource2.getBufferedReader();
                        System.out.println("runtime.mdl reader created");
                    } else {
                        System.out.println("runtime.mdl does not exist");
                    }
                } else {
                    System.out.println("Jar resource is file");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    @Override
    public String toString() {
        return this.getPath();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JarResource)) {
            return false;
        }
        JarResource resource = (JarResource)obj;
        return this.url.equals(resource.getURL());
    }

    public int hashCode() {
        return this.url.hashCode();
    }
}

