/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.util.resource;

import com.objectriver.runtime.util.asserts.Assert;
import com.objectriver.runtime.util.resource.FileResource;
import com.objectriver.runtime.util.resource.JarResource;
import com.objectriver.runtime.util.resource.Resource;
import com.objectriver.runtime.util.resource.ResourceType;
import com.objectriver.runtime.util.resource.UrlHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarFile;

public class ResourceFactory {
    public static Resource valueOf(URL url) {
        if (url == null) {
            return null;
        }
        ResourceType type = ResourceType.valueOf(url.getProtocol());
        Assert.assertTrue("Unknow URL protocol:" + url.getProtocol(), type != null);
        switch (type.intValue()) {
            case 1: {
                String string = url.getFile();
                File file = new File(string);
                return new FileResource(file);
            }
            case 2: {
                return new JarResource(url);
            }
        }
        Assert.fail("Unsupported URl protocol:" + url.getProtocol());
        return null;
    }

    public static Resource valueOf(String urlString, ResourceType defaultType) throws MalformedURLException, FileNotFoundException {
        if (urlString.startsWith("file:")) {
            URL url = new URL(UrlHelper.escape(urlString));
            return new FileResource(url);
        }
        if (urlString.startsWith("jar:")) {
            URL url = new URL(UrlHelper.escape(urlString));
            return new JarResource(url);
        }
        File file = new File(urlString);
        if (file == null) {
            throw new FileNotFoundException(urlString);
        }
        switch (defaultType.intValue()) {
            case 1: {
                return new FileResource(file);
            }
            case 2: {
                JarResource resource = null;
                try {
                    resource = new JarResource(new JarFile(file));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return resource;
            }
        }
        Assert.fail("Unsupported URl protocol: " + defaultType.toString());
        return null;
    }
}

