/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.util.resource;

import com.objectriver.runtime.primitives.PrimitiveEnumeration;
import com.objectriver.runtime.primitives.PrimitiveType;
import com.objectriver.runtime.primitives.abstracts.AbstractEnumeration;
import com.objectriver.runtime.things.Visitor;
import com.objectriver.runtime.util.ArrayIterator;
import com.objectriver.runtime.util.StringUtility;
import com.objectriver.runtime.util.asserts.Assert;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;

public final class ResourceType
extends AbstractEnumeration
implements PrimitiveEnumeration {
    public static final String typeName = "ResourceType";
    private static final String[] _menu = new String[]{"File", "Jar", "Http", "Https", "Json"};
    public static final int FileInt = 1;
    public static final ResourceType File = new ResourceType(_menu[0], 1, _menu[0]);
    public static final int JarInt = 2;
    public static final ResourceType Jar = new ResourceType(_menu[1], 2, _menu[1]);
    public static final int HttpInt = 3;
    public static final ResourceType Http = new ResourceType(_menu[2], 3, _menu[2]);
    public static final int HttpsInt = 4;
    public static final ResourceType Https = new ResourceType(_menu[3], 4, _menu[3]);
    public static final int JsonInt = 5;
    public static final ResourceType Json = new ResourceType(_menu[4], 5, _menu[4]);
    private static final HashMap hashMap = new HashMap(_menu.length);
    private static final ResourceType[] instances;

    public static String[] getMenu() {
        return _menu;
    }

    public static String[] getDescriptions() {
        return _menu;
    }

    public static ResourceType[] getInstances() {
        return instances;
    }

    private ResourceType(String name, int number, String description) {
        super(name, number, description, 2, PrimitiveType.Enumeration);
    }

    @Override
    public PrimitiveEnumeration instanceOf(int enumvalue) {
        return ResourceType.valueOf(enumvalue);
    }

    @Override
    public PrimitiveEnumeration instanceOf(String string) {
        return ResourceType.valueOf(string);
    }

    public static ResourceType valueOf(int enumvalue) {
        switch (enumvalue) {
            case 1: {
                return File;
            }
            case 2: {
                return Jar;
            }
            case 3: {
                return Http;
            }
            case 4: {
                return Https;
            }
            case 5: {
                return Json;
            }
        }
        return null;
    }

    public static ResourceType valueOf(String string) {
        Object enumobject = hashMap.get(string);
        if (enumobject == null && StringUtility.isInteger(string)) {
            return ResourceType.valueOf(Integer.parseInt(string));
        }
        return (ResourceType)enumobject;
    }

    @Override
    public Iterator iterator() {
        return new ArrayIterator(instances);
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String getTypeName() {
        return typeName;
    }

    @Override
    protected boolean acceptVisit(Visitor visitor, boolean decend) {
        Assert.assertTrue(visitor.isTypeVisitor());
        try {
            Method method = visitor.getClass().getMethod("visitOfResourceType", ResourceType.class);
            method.invoke((Object)visitor, this);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (Exception e) {
            Assert.fail("Internal Error");
        }
        return decend;
    }

    public ResourceType valueOfDescription(String description) {
        return ResourceType.valueOf(description);
    }

    static {
        hashMap.put(_menu[0], File);
        hashMap.put("file", File);
        hashMap.put(_menu[1], Jar);
        hashMap.put("jar", Jar);
        hashMap.put(_menu[2], Http);
        hashMap.put("http", Http);
        hashMap.put(_menu[3], Https);
        hashMap.put("https", Https);
        hashMap.put(_menu[4], Json);
        hashMap.put("json", Json);
        instances = new ResourceType[]{File, Jar, Http, Https, Json};
    }
}

