/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.webrpc.exception.beans;

import com.objectriver.runtime.webrpc.exception.beans.WebRpcExceptionStackLocation;

public class WebRpcExceptionCause {
    protected Throwable cause = null;
    protected String type = null;
    protected String message = null;
    protected WebRpcExceptionStackLocation location = null;

    public WebRpcExceptionCause() {
    }

    public WebRpcExceptionCause(Throwable cause) {
        this.cause = cause;
        if (cause != null) {
            this.type = cause.getClass().getSimpleName();
            this.message = cause.getMessage();
            StackTraceElement[] steArray = cause.getStackTrace();
            if (steArray != null && steArray.length != 0) {
                this.location = new WebRpcExceptionStackLocation(steArray[0]);
            }
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public WebRpcExceptionStackLocation getLocation() {
        return this.location;
    }

    public void setLocation(WebRpcExceptionStackLocation location) {
        this.location = location;
    }

    public String toString() {
        String message = this.message != null ? this.getMessage() : " ";
        return this.type + " message:" + "\"" + message + "\" " + (this.location != null ? this.location.toString() : "");
    }
}

