/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.webrpc.json;

import com.objectriver.runtime.webrpc.json.JsonParserException;
import java.math.BigDecimal;
import java.util.LinkedList;
import javax.json.stream.JsonLocation;
import javax.json.stream.JsonParser;

public class JsonParserPlus
implements JsonParser {
    protected final JsonParser parser;
    public LinkedList<Quad> eventStack = new LinkedList();

    public JsonParserPlus(JsonParser parser) {
        this.parser = parser;
    }

    public Quad peek() throws JsonParserException {
        if (!this.hasNext()) {
            throw new JsonParserException("Nothing to peek!");
        }
        Quad quad = this.pop();
        this.eventStack.addLast(quad);
        return quad;
    }

    public void push(Quad quad) {
        this.eventStack.addLast(quad);
    }

    public Quad pop() throws JsonParserException {
        if (!this.hasNext()) {
            throw new JsonParserException("Nothing to pop!");
        }
        if (!this.eventStack.isEmpty()) {
            Quad quad = this.eventStack.removeFirst();
            return quad;
        }
        JsonParser.Event event = this.next();
        String keyname = null;
        JsonParser.Event subevent = null;
        Object value = null;
        switch (event) {
            case END_OBJECT: 
            case END_ARRAY: {
                break;
            }
            case KEY_NAME: {
                keyname = this.parser.getString();
                subevent = this.parser.next();
                value = null;
                switch (subevent) {
                    case START_OBJECT: {
                        event = subevent;
                        break;
                    }
                    case START_ARRAY: {
                        event = subevent;
                        break;
                    }
                    case VALUE_STRING: {
                        value = this.parser.getString();
                        break;
                    }
                    case VALUE_NUMBER: {
                        value = this.parser.getBigDecimal();
                        break;
                    }
                    case VALUE_TRUE: {
                        value = Boolean.TRUE;
                    }
                    case VALUE_FALSE: {
                        value = Boolean.FALSE;
                    }
                    case VALUE_NULL: {
                        value = null;
                    }
                }
                break;
            }
            case VALUE_STRING: 
            case VALUE_NUMBER: 
            case VALUE_TRUE: 
            case VALUE_FALSE: 
            case VALUE_NULL: {
                throw new JsonParserException("Unexspected Event = " + event.toString());
            }
            default: {
                throw new JsonParserException("Unknown Event = " + event.toString());
            }
        }
        return new Quad(event, subevent, keyname, value);
    }

    public Quad popArrayElement() throws JsonParserException {
        if (!this.hasNext()) {
            throw new JsonParserException("Nothing to pop!");
        }
        if (!this.eventStack.isEmpty()) {
            Quad quad = this.eventStack.removeFirst();
            return quad;
        }
        JsonParser.Event event = this.next();
        String keyname = null;
        JsonParser.Event subevent = null;
        Object value = null;
        switch (event) {
            case END_OBJECT: 
            case END_ARRAY: {
                value = null;
                break;
            }
            case KEY_NAME: {
                throw new JsonParserException("Unexspected Event = " + event.toString());
            }
            case START_OBJECT: {
                break;
            }
            case START_ARRAY: {
                event = subevent;
                break;
            }
            case VALUE_STRING: {
                value = this.parser.getString();
                break;
            }
            case VALUE_NUMBER: {
                value = this.parser.getBigDecimal();
                break;
            }
            case VALUE_TRUE: {
                value = Boolean.TRUE;
                break;
            }
            case VALUE_FALSE: {
                value = Boolean.FALSE;
                break;
            }
            case VALUE_NULL: {
                value = null;
                break;
            }
            default: {
                throw new JsonParserException("Unknown Event = " + event.toString());
            }
        }
        return new Quad(event, subevent, keyname, value);
    }

    @Override
    public String getString() {
        return this.parser.getString();
    }

    @Override
    public JsonParser.Event next() {
        if (!this.eventStack.isEmpty()) {
            Quad quad = this.eventStack.pop();
            return quad.event;
        }
        return this.parser.next();
    }

    @Override
    public boolean hasNext() {
        if (!this.eventStack.isEmpty()) {
            return true;
        }
        return this.parser.hasNext();
    }

    @Override
    public boolean isIntegralNumber() {
        return this.parser.isIntegralNumber();
    }

    @Override
    public int getInt() {
        return this.parser.getInt();
    }

    @Override
    public long getLong() {
        return this.parser.getLong();
    }

    @Override
    public BigDecimal getBigDecimal() {
        return this.parser.getBigDecimal();
    }

    @Override
    public JsonLocation getLocation() {
        return this.parser.getLocation();
    }

    @Override
    public void close() {
        this.parser.close();
    }

    public class Quad {
        public JsonParser.Event event;
        public JsonParser.Event subevent;
        public String keyname;
        public Object value;

        public Quad(JsonParser.Event event, JsonParser.Event subevent, String keyname, Object value) {
            this.event = event;
            this.subevent = subevent;
            this.keyname = keyname;
            this.value = value;
        }
    }
}

