/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.webrpc.json.marshals;

import com.objectriver.runtime.util.ArrayHelper;
import com.objectriver.runtime.util.ArrayIterator;
import com.objectriver.runtime.util.asserts.Assert;
import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.json.JSON;
import com.objectriver.runtime.webrpc.json.JsonParserException;
import com.objectriver.runtime.webrpc.json.JsonParserPlus;
import com.objectriver.runtime.webrpc.json.JsonProcT;
import com.objectriver.runtime.webrpc.json.JsonThing;
import com.objectriver.runtime.webrpc.json.marshals.json_int;
import com.objectriver.runtime.webrpc.json.marshals.json_nullable;
import java.lang.reflect.Array;
import java.util.LinkedList;
import javax.json.stream.JsonParser;

public abstract class JsonMarshal
implements JsonProcT {
    private static final byte[] zeros = new byte[]{0, 0, 0, 0};
    public static final String objectelement = "oBjEcTElEmEnT";
    public static final String arrayelement = "jSoNaRrAyElEmEnT";

    protected JsonMarshal() {
    }

    public boolean json_pointer(JSON jsons, JsonThing thing, JsonProcT proc) throws WebRpcMarshallingException {
        block18: {
            if (jsons.x_op == JSON.op.JSON_ENCODE) {
                if (thing.isNull()) {
                    if (!proc.isBean()) {
                        jsons.put_nullElement(thing.getKey());
                    }
                } else {
                    return proc.execute(jsons, thing);
                }
            }
            if (jsons.x_op == JSON.op.JSON_DECODE) {
                try {
                    if (jsons.jParser.hasNext()) {
                        JsonParserPlus.Quad jEvent = jsons.jParser.pop();
                        if (jEvent.keyname == arrayelement) {
                            jEvent.subevent = jEvent.event;
                            jEvent.event = JsonParser.Event.KEY_NAME;
                        }
                        switch (jEvent.event) {
                            case KEY_NAME: {
                                if (!proc.isBean() && !jEvent.keyname.equals(thing.getKey())) {
                                    throw new WebRpcMarshallingException("json_pointer(). key mismatch. expecting " + thing.getKey() + " and got " + jEvent.keyname);
                                }
                                if (jEvent.subevent == JsonParser.Event.START_OBJECT && jsons.jParser.peek().event == JsonParser.Event.END_OBJECT) {
                                    jsons.jParser.pop();
                                    thing.setThing(null);
                                    break;
                                }
                                if (jEvent.value == null && jEvent.subevent == null) {
                                    thing.setThing(null);
                                    break;
                                }
                                jsons.jParser.push(jEvent);
                                return proc.execute(jsons, thing);
                            }
                            case START_OBJECT: {
                                jsons.jParser.push(jEvent);
                                return proc.execute(jsons, thing);
                            }
                            case START_ARRAY: {
                                jsons.jParser.push(jEvent);
                                return proc.execute(jsons, thing);
                            }
                            case END_OBJECT: {
                                thing.setThing(null);
                                jsons.jParser.push(jEvent);
                                break;
                            }
                            default: {
                                throw new WebRpcMarshallingException("json_pointer(). Expected KEY_NAME,START_OBJECT,START_ARRAY got " + jEvent.event.toString());
                            }
                        }
                        break block18;
                    }
                    throw new WebRpcMarshallingException("json_pointer(). No more JSON events?");
                }
                catch (JsonParserException ex) {
                    throw new WebRpcMarshallingException("json_pointer(). " + ex.getMessage(), ex);
                }
            }
        }
        return true;
    }

    public boolean json_reference(JSON jsons, JsonThing thing, JsonProcT proc) throws WebRpcMarshallingException {
        return proc.execute(jsons, thing);
    }

    public boolean json_opaque(JSON jsons, byte[] bytes, int cnt) throws WebRpcMarshallingException {
        if (cnt == 0) {
            return true;
        }
        if (jsons.x_op == JSON.op.JSON_DECODE) {
            jsons.get_bytes(bytes, cnt);
        } else if (jsons.x_op == JSON.op.JSON_ENCODE) {
            jsons.put_bytes(bytes, cnt);
        }
        return true;
    }

    public boolean json_vector(JSON jsons, JsonThing thing1, int nelem, JsonProcT proc) throws WebRpcMarshallingException {
        if (jsons.x_op == JSON.op.JSON_ENCODE) {
            int i;
            Object[] vector = (Object[])thing1.getThing();
            if (!(proc instanceof json_nullable)) {
                for (i = 0; i < nelem; ++i) {
                    if (vector[i] != null) continue;
                    throw new WebRpcMarshallingException("json_vector() class " + proc.getClazz().getName() + " type can not be null! Check webrpc definition.");
                }
            }
            JsonThing thing2 = new JsonThing();
            jsons.startArray(thing1.getKey());
            for (i = 0; i < nelem; ++i) {
                Object elptr = vector[i];
                if (elptr == null) {
                    jsons.put_nullArrayElement();
                } else if (!proc.execute(jsons, thing2.setJvalue(arrayelement, elptr))) {
                    return false;
                }
                if (i + 1 >= nelem) continue;
                jsons.separator();
            }
            jsons.endArray();
        } else if (jsons.x_op == JSON.op.JSON_DECODE) {
            Object[] vector = (Object[])Array.newInstance(proc.getClazz(), nelem);
            JsonThing thing2 = new JsonThing();
            try {
                jsons.startArray(thing1.getKey());
                for (int i = 0; i < nelem; ++i) {
                    JsonParserPlus.Quad arrayMember = jsons.jParser.popArrayElement();
                    arrayMember.keyname = arrayelement;
                    jsons.jParser.push(arrayMember);
                    if (!proc.execute(jsons, thing2.setJvalue(arrayelement, null))) {
                        return false;
                    }
                    vector[i] = thing2.getThing();
                    if (i + 1 >= nelem) continue;
                    jsons.separator();
                }
                thing1.setThing(vector);
                jsons.endArray();
            }
            catch (JsonParserException ex) {
                throw new WebRpcMarshallingException("json_vector(). " + ex.getMessage(), ex);
            }
        }
        return true;
    }

    public boolean json_array(JSON jsons, JsonThing thing1, JsonProcT proc) throws WebRpcMarshallingException {
        return this.json_array(jsons, thing1, Integer.MAX_VALUE, proc);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean json_array(JSON jsons, JsonThing thing, int maxsize, JsonProcT proc) throws WebRpcMarshallingException {
        if (jsons.x_op == JSON.op.JSON_ENCODE) {
            if (thing.isNull()) {
                jsons.put_nullArray(thing.getKey());
                return true;
            }
            Object[] array = (Object[])thing.getThing();
            if (!(proc instanceof json_nullable)) {
                for (int i = 0; i < array.length; ++i) {
                    if (array[i] != null) continue;
                    throw new WebRpcMarshallingException("json_array() class " + proc.getClazz().getName() + " type can not be null! Check webrpc definition.");
                }
            }
            jsons.startArray(thing.getKey());
            ArrayIterator iter = new ArrayIterator(array);
            while (iter.hasNext()) {
                Object object = iter.next();
                if (object == null) {
                    if (proc.isBean()) {
                        jsons.put_nullObjectInArray();
                    } else {
                        jsons.put_nullArrayElement();
                    }
                } else {
                    if (proc.isBean()) {
                        jsons.startObject(null);
                    }
                    if (!proc.execute(jsons, new JsonThing(arrayelement, object))) {
                        return false;
                    }
                    if (proc.isBean()) {
                        jsons.endObject();
                    }
                }
                if (!iter.hasNext()) continue;
                jsons.separator();
            }
            jsons.endArray();
            return true;
        }
        if (jsons.x_op != JSON.op.JSON_DECODE) return true;
        try {
            LinkedList<Object> list = new LinkedList<Object>();
            if (!jsons.jParser.hasNext()) throw new WebRpcMarshallingException("json_array(). No more JSON events?");
            JsonParserPlus.Quad jEvent = jsons.jParser.pop();
            switch (jEvent.event) {
                case START_ARRAY: {
                    if (!jEvent.keyname.equals(thing.getKey())) {
                        throw new WebRpcMarshallingException("json_array(). key mismatch. expecting " + thing.getKey() + " and got " + jEvent.keyname);
                    }
                    JsonParserPlus.Quad subEvent = jsons.jParser.popArrayElement();
                    if (subEvent.value == JsonParser.Event.END_ARRAY) {
                        Object[] array = ArrayHelper.recast(proc.getClazz(), new Object[0]);
                        thing.setThing(array);
                        return true;
                    }
                    jsons.jParser.push(subEvent);
                    while (true) {
                        JsonParserPlus.Quad arrayMember = jsons.jParser.popArrayElement();
                        if (arrayMember.event == JsonParser.Event.END_ARRAY) break;
                        arrayMember.keyname = arrayelement;
                        jsons.jParser.push(arrayMember);
                        if (proc.isBean()) {
                            jsons.startObject(null);
                        }
                        proc.execute(jsons, thing.setJvalue(arrayelement, null));
                        if (proc.isBean()) {
                            jsons.endObject();
                        }
                        list.add(thing.getThing());
                    }
                    thing.setThing(ArrayHelper.recast(proc.getClazz(), list.toArray()));
                    return true;
                }
                case KEY_NAME: {
                    Assert.fail("implement START_OBJECT json_array");
                    return true;
                }
                case START_OBJECT: {
                    Assert.fail("implement START_ARRAY json_array");
                    return true;
                }
                default: {
                    throw new WebRpcMarshallingException("json_array(). Expected KEY_NAME,START_OBJECT,START_ARRAY got " + jEvent.event.toString());
                }
            }
        }
        catch (JsonParserException ex) {
            throw new WebRpcMarshallingException("json_array(). " + ex.getMessage(), ex);
        }
    }

    public boolean json_bytes(JSON jsons, JsonThing thing, JsonProcT proc) throws WebRpcMarshallingException {
        JsonThing thing2;
        Integer size = 0;
        byte[] bytes = null;
        if (jsons.x_op == JSON.op.JSON_ENCODE) {
            bytes = (byte[])thing.getThing();
            size = bytes == null ? 0 : bytes.length;
        }
        if (!json_int.instance.execute(jsons, thing2 = new JsonThing("size", size))) {
            return false;
        }
        size = (Integer)thing2.getThing();
        switch (jsons.x_op) {
            case JSON_DECODE: {
                if (size == 0) {
                    thing.setThing(null);
                    return true;
                }
                byte[] decoded = new byte[size.intValue()];
                if (this.json_opaque(jsons, decoded, size)) {
                    thing.setThing(decoded);
                    return true;
                }
                return false;
            }
            case JSON_ENCODE: {
                if (size == 0) {
                    return true;
                }
                return this.json_opaque(jsons, bytes, size);
            }
        }
        return false;
    }

    @Override
    public abstract Class getClazz();

    @Override
    public boolean isBean() {
        return false;
    }
}

