/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.webrpc.json.marshals;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.json.JSON;
import com.objectriver.runtime.webrpc.json.JsonThing;
import com.objectriver.runtime.webrpc.json.marshals.JsonMarshal;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import javax.json.stream.JsonParsingException;

public class json_bool
extends JsonMarshal {
    public static json_bool instance = new json_bool();

    @Override
    public boolean execute(JSON jsons, JsonThing thing) throws WebRpcMarshallingException {
        try {
            if (jsons.x_op == JSON.op.JSON_ENCODE) {
                Boolean bool = (Boolean)thing.getThing();
                if (bool == null) {
                    throw new WebRpcMarshallingException("json_bool() bool type can not be null! try defining as Boolean.");
                }
                jsons.put_bool(thing.getKey(), bool);
                return true;
            }
            if (jsons.x_op == JSON.op.JSON_DECODE) {
                Boolean value = jsons.get_bool(thing.getKey());
                thing.setThing(value);
                return true;
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("json_bool(): " + ex.getMessage(), ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("json_bool(): " + ex.getMessage(), ex);
        }
        catch (JsonParsingException ex) {
            throw new WebRpcMarshallingException("json_bool: " + ex.getMessage(), ex);
        }
        return false;
    }

    @Override
    public Class getClazz() {
        return Boolean.class;
    }
}

