/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.webrpc.json.marshals;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.json.JSON;
import com.objectriver.runtime.webrpc.json.JsonThing;
import com.objectriver.runtime.webrpc.json.marshals.JsonMarshal;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import javax.json.stream.JsonParsingException;

public class json_byte
extends JsonMarshal {
    public static json_byte instance = new json_byte();

    private json_byte() {
    }

    @Override
    public boolean execute(JSON jsons, JsonThing thing) throws WebRpcMarshallingException {
        try {
            if (jsons.x_op == JSON.op.JSON_ENCODE) {
                Byte bite = (Byte)thing.getThing();
                if (bite == null) {
                    throw new WebRpcMarshallingException("json_byte() byte type can not be null! try defining as Byte.");
                }
                jsons.put_int(thing.getKey(), bite.intValue());
                return true;
            }
            if (jsons.x_op == JSON.op.JSON_DECODE) {
                Integer value = jsons.get_int(thing.getKey());
                thing.setThing(value.byteValue());
                return true;
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("json_byte: " + ex.getMessage(), ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("json_byte: " + ex.getMessage(), ex);
        }
        catch (JsonParsingException ex) {
            throw new WebRpcMarshallingException("json_byte: " + ex.getMessage(), ex);
        }
        return false;
    }

    @Override
    public Class getClazz() {
        return Byte.class;
    }
}

