/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.webrpc.json.marshals;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.json.JSON;
import com.objectriver.runtime.webrpc.json.JsonThing;
import com.objectriver.runtime.webrpc.json.marshals.JsonMarshal;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.sql.Date;
import javax.json.stream.JsonParsingException;

public class json_date
extends JsonMarshal {
    public static json_date instance = new json_date();

    private json_date() {
    }

    @Override
    public boolean execute(JSON jsons, JsonThing thing) throws WebRpcMarshallingException {
        try {
            if (jsons.x_op == JSON.op.JSON_ENCODE) {
                Date date = (Date)thing.getThing();
                if (date == null) {
                    throw new WebRpcMarshallingException("json_date() date type can not be null! try defining as Date.");
                }
                jsons.put_long(thing.getKey(), date.getTime());
                return true;
            }
            if (jsons.x_op == JSON.op.JSON_DECODE) {
                long time = jsons.get_long(thing.getKey());
                Date date = new Date(time);
                thing.setThing(date);
                return true;
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("json_date: " + ex.getMessage(), ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("json_date: " + ex.getMessage(), ex);
        }
        catch (JsonParsingException ex) {
            throw new WebRpcMarshallingException("json_date: " + ex.getMessage(), ex);
        }
        return false;
    }

    @Override
    public Class getClazz() {
        return Date.class;
    }
}

