/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.webrpc.json.marshals;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.json.JSON;
import com.objectriver.runtime.webrpc.json.JsonThing;
import com.objectriver.runtime.webrpc.json.marshals.JsonMarshal;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import javax.json.stream.JsonParsingException;

public class json_float
extends JsonMarshal {
    public static json_float instance = new json_float();

    private json_float() {
    }

    @Override
    public boolean execute(JSON jsons, JsonThing thing) throws WebRpcMarshallingException {
        try {
            if (jsons.x_op == JSON.op.JSON_ENCODE) {
                Float flt = (Float)thing.getThing();
                if (flt == null) {
                    throw new WebRpcMarshallingException("json_float() float type can not be null! try defining as Float.");
                }
                jsons.put_float(thing.getKey(), flt);
                return true;
            }
            if (jsons.x_op == JSON.op.JSON_DECODE) {
                Float value = jsons.get_float(thing.getKey());
                thing.setThing(value);
                return true;
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("json_float: " + ex.getMessage(), ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("json_float: " + ex.getMessage(), ex);
        }
        catch (JsonParsingException ex) {
            throw new WebRpcMarshallingException("json_float: " + ex.getMessage(), ex);
        }
        return false;
    }

    @Override
    public Class getClazz() {
        return Float.class;
    }
}

