/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.webrpc.json.marshals;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.json.JSON;
import com.objectriver.runtime.webrpc.json.JsonThing;
import com.objectriver.runtime.webrpc.json.marshals.JsonMarshal;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import javax.json.stream.JsonParsingException;

public class json_long
extends JsonMarshal {
    public static json_long instance = new json_long();

    private json_long() {
    }

    @Override
    public boolean execute(JSON jsons, JsonThing thing) throws WebRpcMarshallingException {
        try {
            if (jsons.x_op == JSON.op.JSON_ENCODE) {
                Long lng = (Long)thing.getThing();
                if (lng == null) {
                    throw new WebRpcMarshallingException("json_long() long type can not be null! try defining as Long.");
                }
                jsons.put_long(thing.getKey(), lng);
                return true;
            }
            if (jsons.x_op == JSON.op.JSON_DECODE) {
                Long value = jsons.get_long(thing.getKey());
                thing.setThing(value);
                return true;
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("json_long: " + ex.getMessage(), ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("json_long: " + ex.getMessage(), ex);
        }
        catch (JsonParsingException ex) {
            throw new WebRpcMarshallingException("json_long: " + ex.getMessage(), ex);
        }
        return false;
    }

    @Override
    public Class getClazz() {
        return Long.class;
    }
}

