/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.webrpc.json.marshals;

import com.objectriver.runtime.util.asserts.Assert;
import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.json.JSON;
import com.objectriver.runtime.webrpc.json.JsonThing;
import com.objectriver.runtime.webrpc.json.marshals.JsonMarshal;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.stream.JsonParsingException;

public class json_string
extends JsonMarshal {
    public static json_string instance = new json_string();
    static Pattern pattern = Pattern.compile("[\\0134\\0042\\0010\\0013\\0015]");
    static Map map = new HashMap();

    private json_string() {
    }

    public boolean execute(JSON jsons, JsonThing thing, boolean notnull) throws WebRpcMarshallingException {
        if (notnull && jsons.x_op == JSON.op.JSON_ENCODE && thing.isNull()) {
            throw new WebRpcMarshallingException("json_string() string type can not be null! try defining as String.");
        }
        return this.execute(jsons, thing);
    }

    @Override
    public boolean execute(JSON jsons, JsonThing thing) throws WebRpcMarshallingException {
        try {
            if (jsons.x_op == JSON.op.JSON_ENCODE) {
                String jsonString = (String)thing.getThing();
                if (jsonString != null) {
                    jsonString = json_string.jSonCharReplacer(jsonString);
                }
                jsons.put_string(thing.getKey(), jsonString);
                return true;
            }
            if (jsons.x_op == JSON.op.JSON_DECODE) {
                String value = jsons.get_string(thing.getKey());
                thing.setThing(value);
                return true;
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("json_string: " + ex.getMessage(), ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("json_string: " + ex.getMessage(), ex);
        }
        catch (JsonParsingException ex) {
            throw new WebRpcMarshallingException("json_string: " + ex.getMessage(), ex);
        }
        return false;
    }

    @Override
    public Class getClazz() {
        return String.class;
    }

    public static String jSonCharReplacer(String input) {
        Matcher match = pattern.matcher(input);
        if (match.find()) {
            StringBuilder builder = new StringBuilder();
            int len = input.length();
            for (int cc = 0; cc < len; ++cc) {
                char c = input.charAt(cc);
                String replacement = (String)map.get(Character.valueOf(c));
                if (replacement != null) {
                    builder.append(replacement);
                    continue;
                }
                builder.append(c);
            }
            input = builder.toString();
        }
        return input;
    }

    public static void main(String[] args) {
        String line = "fred\\[]{}fred";
        line = json_string.jSonCharReplacer(line);
        String compare = "fred\\\\[]{}fred";
        Assert.assertTrue(line.equals(compare));
    }

    static {
        map.put(Character.valueOf('\\'), "\\\\");
        map.put(Character.valueOf('\n'), "\\u000A");
        map.put(Character.valueOf('\t'), "\\u000B");
        map.put(Character.valueOf('\r'), "\\u000D");
        map.put(Character.valueOf('\"'), "\\\"");
    }
}

