/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.webrpc.json.marshals;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.json.JSON;
import com.objectriver.runtime.webrpc.json.JsonThing;
import com.objectriver.runtime.webrpc.json.marshals.JsonMarshal;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.sql.Timestamp;
import javax.json.stream.JsonParsingException;

public class json_timestamp
extends JsonMarshal {
    public static json_timestamp instance = new json_timestamp();

    private json_timestamp() {
    }

    @Override
    public boolean execute(JSON jsons, JsonThing thing) throws WebRpcMarshallingException {
        try {
            if (jsons.x_op == JSON.op.JSON_ENCODE) {
                Timestamp ts = (Timestamp)thing.getThing();
                if (ts == null) {
                    throw new WebRpcMarshallingException("json_timestamp() timestamp type can not be null! try defining as TimeStamp.");
                }
                jsons.put_long(thing.getKey(), ts.getTime());
                return true;
            }
            if (jsons.x_op == JSON.op.JSON_DECODE) {
                long time = jsons.get_long(thing.getKey());
                Timestamp ts = new Timestamp(time);
                thing.setThing(ts);
                return true;
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("json_timestamp: " + ex.getMessage(), ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("json_timestamp: " + ex.getMessage(), ex);
        }
        catch (JsonParsingException ex) {
            throw new WebRpcMarshallingException("json_timestamp: " + ex.getMessage(), ex);
        }
        return false;
    }

    @Override
    public Class getClazz() {
        return Timestamp.class;
    }
}

