/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.webrpc.properties;

import com.objectriver.runtime.webrpc.exception.WebRpcRuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class WebRpcProperties {
    public static Properties getPropertiesFromEnv(String envdir, String filename) throws WebRpcRuntimeException {
        String propdir = System.getenv(envdir);
        if (propdir == null) {
            throw new WebRpcRuntimeException("Property " + envdir + " env varaible not defined");
        }
        File propfile = new File(propdir + File.separator + filename);
        return WebRpcProperties.getPropertiesFromFile(propfile);
    }

    public static Properties getPropertiesFromFile(File file) throws WebRpcRuntimeException {
        try {
            if (!file.exists()) {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
            Properties webrpcProperties = new Properties();
            FileInputStream stream = new FileInputStream(file);
            webrpcProperties.load(stream);
            ((InputStream)stream).close();
            return webrpcProperties;
        }
        catch (FileNotFoundException fnfe) {
            throw new WebRpcRuntimeException("Properties file " + file.getName() + " file not found", fnfe);
        }
        catch (IOException ioe) {
            throw new WebRpcRuntimeException("Properties file " + file.getName() + "IOException", ioe);
        }
    }

    public static Properties getProperties(String fileName) throws WebRpcRuntimeException {
        try {
            Properties webrpcProperties = new Properties();
            URL url = Properties.class.getResource("/" + fileName);
            if (url == null) {
                throw new WebRpcRuntimeException("Properties file " + fileName + " file not found");
            }
            InputStream stream = url.openStream();
            webrpcProperties.load(stream);
            stream.close();
            return webrpcProperties;
        }
        catch (FileNotFoundException fnfe) {
            throw new WebRpcRuntimeException("Properties file " + fileName + " file not found", fnfe);
        }
        catch (IOException ioe) {
            throw new WebRpcRuntimeException("Properties file " + fileName + "IOException", ioe);
        }
    }
}

