/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.webrpc.server;

import com.objectriver.runtime.webrpc.exception.WebRpcServerException;
import com.objectriver.runtime.webrpc.server.ServerType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;

public class Server {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch(String serverType, String host, int port, String rootPath, Class serverApplicationConfig) throws WebRpcServerException {
        ServerType sType = ServerType.valueOf(serverType);
        if (sType == null) {
            throw new WebRpcServerException("Unknown server type? " + serverType);
        }
        try {
            switch (sType.intValue()) {
                case 0: 
                case 1: {
                    Class<?> serverClass = Class.forName("org.glassfish.tyrus.server.Server");
                    Constructor<?> serverConstructor = serverClass.getConstructor(String.class, Integer.TYPE, String.class, Map.class, Class[].class);
                    Object[] args = new Object[]{host, port, rootPath, Collections.emptyMap(), new Class[]{serverApplicationConfig}};
                    Object serverObj = serverConstructor.newInstance(args);
                    Method startMethod = serverClass.getMethod("start", null);
                    startMethod.invoke(serverObj, null);
                    Server server = this;
                    synchronized (server) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        break;
                    }
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    throw new WebRpcServerException("Server type " + serverType + " not supported yet :( Try tyrus as workaround for now.");
                }
                default: {
                    throw new WebRpcServerException("Unknown server type: " + serverType);
                }
            }
        }
        catch (ClassNotFoundException ex) {
            throw new WebRpcServerException("ClassNotFound exception trying to launch " + serverType + " Server. Check webrpc.properties and classpath", ex);
        }
        catch (InstantiationException ex) {
            throw new WebRpcServerException("Reflection exception trying to launch " + serverType + " Server.", ex);
        }
        catch (NoSuchMethodException ex) {
            throw new WebRpcServerException("Reflection exception trying to launch " + serverType + " Server.", ex);
        }
        catch (InvocationTargetException ex) {
            throw new WebRpcServerException("Reflection exception trying to launch " + serverType + " Server.", ex);
        }
        catch (IllegalAccessException ex) {
            throw new WebRpcServerException("Reflection exception trying to launch " + serverType + " Server.", ex);
        }
    }

    public synchronized void shutdown() {
        this.notify();
    }
}

