/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.webrpc.util;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ISO8601DateTimeSingleton {
    private static DateFormat timestampformat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd'T'00:00:00.000'Z'");
    private static ISO8601DateTimeSingleton instance = new ISO8601DateTimeSingleton();
    private static final Pattern pattern = Pattern.compile("^(\\d\\d\\d\\d-\\d\\d-\\d\\d)([T ]?(\\d\\d:\\d\\d:\\d\\d)?[.]?(\\d\\d\\d)?([Z]|\\+\\d\\d\\d\\d)?)?");

    private ISO8601DateTimeSingleton() {
    }

    public static ISO8601DateTimeSingleton getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIsoDate(java.sql.Date date) {
        String isodate;
        DateFormat dateFormat = dateformat;
        synchronized (dateFormat) {
            isodate = dateformat.format(date);
        }
        return isodate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIsoDate(Timestamp ts) {
        String isots;
        DateFormat dateFormat = timestampformat;
        synchronized (dateFormat) {
            isots = timestampformat.format(ts);
        }
        return isots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Date> T parseDateTime(T datetype, String isodate) throws ParseException {
        Date utilDate;
        isodate = ISO8601DateTimeSingleton.constructIsoDateTime(isodate);
        DateFormat dateFormat = timestampformat;
        synchronized (dateFormat) {
            utilDate = timestampformat.parse(isodate);
        }
        datetype.setTime(utilDate.getTime());
        return datetype;
    }

    public static void main(String[] agrs) {
        System.out.println(ISO8601DateTimeSingleton.constructIsoDateTime("2018-12-12"));
        System.out.println(ISO8601DateTimeSingleton.constructIsoDateTime("2018-12-12 12:12:12"));
        System.out.println(ISO8601DateTimeSingleton.constructIsoDateTime("2018-12-12 12:12:12.123"));
        System.out.println(ISO8601DateTimeSingleton.constructIsoDateTime("2018-12-12T12:12:12.123Z"));
        System.out.println(ISO8601DateTimeSingleton.constructIsoDateTime("2018-12-12T12:12:12.123+0000"));
    }

    private static String constructIsoDateTime(String isodate) {
        Matcher matcher;
        if (isodate.length() > 8 && isodate.charAt(4) == '-' && (matcher = pattern.matcher(isodate)).matches()) {
            if (matcher.group(1) != null) {
                isodate = matcher.group(1);
            }
            if (matcher.group(3) != null) {
                isodate = isodate + 'T' + matcher.group(3);
                isodate = matcher.group(4) != null ? isodate + '.' + matcher.group(4) + 'Z' : isodate + ".000Z";
            } else {
                isodate = isodate + "T00:00:00.00Z";
            }
        }
        return isodate;
    }
}

