/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.webrpc.xdr;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class XDR {
    public DataInputStream instream;
    public DataOutputStream outstream;
    public ByteBuffer byteBuffer = null;
    public static final int BYTES_PER_XDR_UNIT = 1;
    public static final byte XDR_TRUE = (byte)1;
    public static final byte XDR_FALSE = (byte)0;
    public op x_op;
    public int version;

    private XDR() {
    }

    public XDR(InputStream input) {
        this.instream = new DataInputStream(input);
        this.x_op = op.XDR_DECODE;
    }

    public XDR(OutputStream output) {
        this.outstream = new DataOutputStream(output);
        this.x_op = op.XDR_ENCODE;
    }

    public XDR(ByteBuffer bb, op op2) {
        this.byteBuffer = bb;
        this.x_op = op2;
    }

    public void close() {
        try {
            if (this.byteBuffer == null) {
                if (this.x_op == op.XDR_DECODE) {
                    this.instream.close();
                } else {
                    this.outstream.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public op getX_op() {
        return this.x_op;
    }

    public void setX_op(op x_op) {
        this.x_op = x_op;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int envelope_version) {
        this.version = envelope_version;
    }

    public void put_int(Integer value) throws WebRpcMarshallingException {
        if (this.byteBuffer == null) {
            try {
                this.outstream.writeInt(value);
            }
            catch (IOException ioex) {
                throw new WebRpcMarshallingException("put_int()", ioex);
            }
        } else {
            this.byteBuffer.putInt(value);
        }
    }

    public Integer get_int() throws WebRpcMarshallingException {
        if (this.byteBuffer == null) {
            try {
                return this.instream.readInt();
            }
            catch (IOException ioex) {
                throw new WebRpcMarshallingException("get_int()", ioex);
            }
        }
        return this.byteBuffer.getInt();
    }

    public void put_long(Long value) throws WebRpcMarshallingException {
        if (this.byteBuffer == null) {
            try {
                this.outstream.writeLong(value);
            }
            catch (IOException ioex) {
                throw new WebRpcMarshallingException("put_long()", ioex);
            }
        } else {
            this.byteBuffer.putLong(value);
        }
    }

    public Long get_long() throws WebRpcMarshallingException {
        if (this.byteBuffer == null) {
            try {
                return this.instream.readLong();
            }
            catch (IOException ioex) {
                throw new WebRpcMarshallingException("get_long()", ioex);
            }
        }
        return this.byteBuffer.getLong();
    }

    public void put_float(Float value) throws WebRpcMarshallingException {
        if (this.byteBuffer == null) {
            try {
                this.outstream.writeFloat(value.floatValue());
            }
            catch (IOException ioex) {
                throw new WebRpcMarshallingException("put_float()", ioex);
            }
        } else {
            this.byteBuffer.putFloat(value.floatValue());
        }
    }

    public Float get_float() throws WebRpcMarshallingException {
        if (this.byteBuffer == null) {
            try {
                return Float.valueOf(this.instream.readFloat());
            }
            catch (IOException ioex) {
                throw new WebRpcMarshallingException("get_float()", ioex);
            }
        }
        return Float.valueOf(this.byteBuffer.getFloat());
    }

    public void put_double(Double value) throws WebRpcMarshallingException {
        if (this.byteBuffer == null) {
            try {
                this.outstream.writeDouble(value);
            }
            catch (IOException ioex) {
                throw new WebRpcMarshallingException("put_double()", ioex);
            }
        } else {
            this.byteBuffer.putDouble(value);
        }
    }

    public Double get_double() throws WebRpcMarshallingException {
        if (this.byteBuffer == null) {
            try {
                return this.instream.readDouble();
            }
            catch (IOException ioex) {
                throw new WebRpcMarshallingException("get_double()", ioex);
            }
        }
        return this.byteBuffer.getDouble();
    }

    public void put_char(Character value) throws WebRpcMarshallingException {
        if (this.byteBuffer == null) {
            try {
                this.outstream.writeChar(value.charValue());
            }
            catch (IOException ioex) {
                throw new WebRpcMarshallingException("put_char()", ioex);
            }
        } else {
            this.byteBuffer.putChar(value.charValue());
        }
    }

    public Character get_char() throws WebRpcMarshallingException {
        if (this.byteBuffer == null) {
            try {
                return Character.valueOf(this.instream.readChar());
            }
            catch (IOException ioex) {
                throw new WebRpcMarshallingException("get_char()", ioex);
            }
        }
        return Character.valueOf(this.byteBuffer.getChar());
    }

    public void put_byte(byte value) throws WebRpcMarshallingException {
        if (this.byteBuffer == null) {
            try {
                this.outstream.write(value);
            }
            catch (IOException ioex) {
                throw new WebRpcMarshallingException("put_byte()", ioex);
            }
        } else {
            this.byteBuffer.put(value);
        }
    }

    public byte get_byte() throws WebRpcMarshallingException {
        if (this.byteBuffer == null) {
            try {
                return this.instream.readByte();
            }
            catch (IOException ioex) {
                throw new WebRpcMarshallingException("get_byte()", ioex);
            }
        }
        return this.byteBuffer.get();
    }

    public void put_bytes(byte[] value, int length) throws WebRpcMarshallingException {
        if (this.byteBuffer == null) {
            try {
                this.outstream.write(value, 0, length);
            }
            catch (IOException ioex) {
                throw new WebRpcMarshallingException("put_bytes()", ioex);
            }
        } else {
            this.byteBuffer.put(value, 0, length);
        }
    }

    public byte[] get_bytes(byte[] value, int length) throws WebRpcMarshallingException {
        if (this.byteBuffer == null) {
            try {
                this.instream.read(value, 0, length);
            }
            catch (IOException ioex) {
                throw new WebRpcMarshallingException("get_bytes()", ioex);
            }
        } else {
            this.byteBuffer.get(value, 0, length);
        }
        return value;
    }

    public static enum op {
        XDR_ENCODE,
        XDR_DECODE,
        XDR_FREE;

    }
}

