/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.webrpc.xdr.marshals;

import com.objectriver.runtime.util.ArrayHelper;
import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.xdr.XDR;
import com.objectriver.runtime.webrpc.xdr.XdrProcT;
import com.objectriver.runtime.webrpc.xdr.XdrThing;
import com.objectriver.runtime.webrpc.xdr.marshals.xdr_bool;
import com.objectriver.runtime.webrpc.xdr.marshals.xdr_byte;
import com.objectriver.runtime.webrpc.xdr.marshals.xdr_int;
import com.objectriver.runtime.webrpc.xdr.marshals.xdr_nullable;
import java.lang.reflect.Array;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

public abstract class XdrMarshal
implements XdrProcT {
    private static final byte[] zeros = new byte[]{0, 0, 0, 0};

    public boolean xdr_pointer(XDR xdrs, XdrThing thing, XdrProcT proc) throws WebRpcMarshallingException {
        Boolean more_data = thing.getThing() != null;
        XdrThing moreDataThing = new XdrThing(more_data);
        if (!xdr_bool.instance.execute(xdrs, moreDataThing)) {
            return false;
        }
        more_data = (Boolean)moreDataThing.getThing();
        if (!more_data.booleanValue()) {
            thing.setThing(null);
            return true;
        }
        return this.xdr_reference(xdrs, thing, -1, proc);
    }

    public boolean xdr_reference(XDR xdrs, XdrThing thing, int size, XdrProcT proc) throws WebRpcMarshallingException {
        return proc.execute(xdrs, thing);
    }

    public boolean xdr_opaque(XDR xdrs, byte[] bytes, int cnt) throws WebRpcMarshallingException {
        if (cnt == 0) {
            return true;
        }
        int rndup = cnt % 1;
        if (rndup > 0) {
            rndup = 1 - rndup;
        }
        if (xdrs.x_op == XDR.op.XDR_DECODE) {
            xdrs.get_bytes(bytes, cnt);
            if (rndup == 0) {
                return true;
            }
            xdrs.get_bytes(new byte[1], rndup);
        } else if (xdrs.x_op == XDR.op.XDR_ENCODE) {
            xdrs.put_bytes(bytes, cnt);
            if (rndup == 0) {
                return true;
            }
            xdrs.put_bytes(zeros, rndup);
        }
        return true;
    }

    public boolean xdr_vector(XDR xdrs, XdrThing thing1, int nelem, XdrProcT proc) throws WebRpcMarshallingException {
        int i;
        Object[] vector = (Object[])thing1.getThing();
        if (xdrs.x_op == XDR.op.XDR_DECODE) {
            vector = (Object[])Array.newInstance(proc.getClazz(), nelem);
        } else if (xdrs.x_op == XDR.op.XDR_ENCODE && !(proc instanceof xdr_nullable)) {
            for (i = 0; i < nelem; ++i) {
                if (vector[i] != null) continue;
                throw new WebRpcMarshallingException("xdr_vector() class " + proc.getClazz().getName() + " type can not be null! Check webrpc definition.");
            }
        }
        XdrThing thing2 = new XdrThing();
        for (i = 0; i < nelem; ++i) {
            Object elptr = vector[i];
            if (!proc.execute(xdrs, thing2.setThing(elptr))) {
                return false;
            }
            if (xdrs.x_op != XDR.op.XDR_DECODE) continue;
            vector[i] = thing2.getThing();
        }
        if (xdrs.x_op == XDR.op.XDR_DECODE) {
            thing1.setThing(vector);
        }
        return true;
    }

    public boolean xdr_array(XDR xdrs, XdrThing thing1, int maxsize, XdrProcT proc) throws WebRpcMarshallingException {
        int i;
        if (proc == xdr_byte.instance) {
            return this.xdr_bytes(xdrs, thing1);
        }
        XdrThing thing2 = new XdrThing();
        Object[] array = (Object[])thing1.getThing();
        int sizep = array == null ? 0 : array.length;
        boolean stat = true;
        if (!xdr_int.instance.execute(xdrs, thing2.setThing(sizep))) {
            return false;
        }
        sizep = (Integer)thing2.getThing();
        int count = sizep;
        if (count > maxsize && xdrs.x_op != XDR.op.XDR_FREE) {
            return false;
        }
        if (thing1.isNull()) {
            switch (xdrs.x_op) {
                case XDR_DECODE: {
                    if (count == 0) {
                        array = ArrayHelper.recast(proc.getClazz(), new Object[0]);
                        thing1.setThing(array);
                        return true;
                    }
                    array = new Object[count];
                }
            }
        }
        if (xdrs.x_op == XDR.op.XDR_ENCODE && !(proc instanceof xdr_nullable)) {
            for (i = 0; i < count; ++i) {
                if (array[i] != null) continue;
                throw new WebRpcMarshallingException("xdr_array() class " + proc.getClazz().getName() + " type can not be null! Check webrpc definition.");
            }
        }
        for (i = 0; i < count && stat; ++i) {
            stat = proc.execute(xdrs, thing2.setThing(array[i]));
            if (xdrs.x_op != XDR.op.XDR_DECODE) continue;
            array[i] = thing2.getThing();
        }
        if (xdrs.x_op == XDR.op.XDR_DECODE) {
            array = ArrayHelper.recast(proc.getClazz(), array);
            thing1.setThing(array);
        }
        return stat;
    }

    public boolean xdr_bytes(XDR xdrs, XdrThing thing) throws WebRpcMarshallingException {
        Integer size = 0;
        byte[] bytes = null;
        try {
            XdrThing thing2;
            if (xdrs.x_op == XDR.op.XDR_ENCODE) {
                bytes = (byte[])thing.getThing();
                size = bytes == null ? 0 : bytes.length;
            }
            if (!xdr_int.instance.execute(xdrs, thing2 = new XdrThing(size))) {
                return false;
            }
            size = (Integer)thing2.getThing();
            switch (xdrs.x_op) {
                case XDR_DECODE: {
                    if (size == 0) {
                        thing.setThing(null);
                        return true;
                    }
                    byte[] decoded = new byte[size.intValue()];
                    if (this.xdr_opaque(xdrs, decoded, size)) {
                        thing.setThing(decoded);
                        return true;
                    }
                    return false;
                }
                case XDR_ENCODE: {
                    if (size == 0) {
                        return true;
                    }
                    return this.xdr_opaque(xdrs, bytes, size);
                }
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("xdr_bytes", ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("xdr_bytes", ex);
        }
        return false;
    }

    @Override
    public abstract Class getClazz();
}

