/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.webrpc.xdr.marshals;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.xdr.XDR;
import com.objectriver.runtime.webrpc.xdr.XdrThing;
import com.objectriver.runtime.webrpc.xdr.marshals.XdrMarshal;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

public class xdr_char
extends XdrMarshal {
    public static xdr_char instance = new xdr_char();

    private xdr_char() {
    }

    @Override
    public boolean execute(XDR xdrs, XdrThing thing) throws WebRpcMarshallingException {
        try {
            if (xdrs.x_op == XDR.op.XDR_ENCODE) {
                Character chr = (Character)thing.getThing();
                if (chr == null) {
                    throw new WebRpcMarshallingException("xdr_char() char type can not be null! try defining as Character.");
                }
                xdrs.put_int(Integer.valueOf(chr.charValue()));
                return true;
            }
            if (xdrs.x_op == XDR.op.XDR_DECODE) {
                Integer chr = xdrs.get_int();
                thing.setThing(Character.valueOf((char)chr.byteValue()));
                return true;
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("xdr_char", ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("xdr_char", ex);
        }
        return xdrs.x_op == XDR.op.XDR_FREE;
    }

    @Override
    public Class getClazz() {
        return Character.class;
    }
}

