/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.webrpc.xdr.marshals;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.xdr.XDR;
import com.objectriver.runtime.webrpc.xdr.XdrThing;
import com.objectriver.runtime.webrpc.xdr.marshals.XdrMarshal;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.sql.Date;

public class xdr_date
extends XdrMarshal {
    public static xdr_date instance = new xdr_date();

    @Override
    public boolean execute(XDR xdrs, XdrThing thing) throws WebRpcMarshallingException {
        try {
            if (xdrs.x_op == XDR.op.XDR_ENCODE) {
                Date date = (Date)thing.getThing();
                if (date == null) {
                    throw new WebRpcMarshallingException("xdr_date() date type can not be null! try defining as Date.");
                }
                xdrs.put_long(date.getTime());
                return true;
            }
            if (xdrs.x_op == XDR.op.XDR_DECODE) {
                long time = xdrs.get_long();
                Date date = new Date(time);
                thing.setThing(date);
                return true;
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("xdr_date()", ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("xdr_date()", ex);
        }
        return xdrs.x_op == XDR.op.XDR_FREE;
    }

    @Override
    public Class getClazz() {
        return Date.class;
    }
}

