/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.webrpc.xdr.marshals;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.xdr.XDR;
import com.objectriver.runtime.webrpc.xdr.XdrThing;
import com.objectriver.runtime.webrpc.xdr.marshals.XdrMarshal;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

public class xdr_float
extends XdrMarshal {
    public static xdr_float instance = new xdr_float();

    private xdr_float() {
    }

    @Override
    public boolean execute(XDR xdrs, XdrThing thing) throws WebRpcMarshallingException {
        try {
            if (xdrs.x_op == XDR.op.XDR_ENCODE) {
                Float flt = (Float)thing.getThing();
                if (flt == null) {
                    throw new WebRpcMarshallingException("xdr_float() float type can not be null! try defining as Float.");
                }
                xdrs.put_float(flt);
                return true;
            }
            if (xdrs.x_op == XDR.op.XDR_DECODE) {
                thing.setThing(xdrs.get_float());
                return true;
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("xdr_float", ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("xdr_float", ex);
        }
        return xdrs.x_op == XDR.op.XDR_FREE;
    }

    @Override
    public Class getClazz() {
        return Float.class;
    }
}

