/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.webrpc.xdr.marshals;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.xdr.XDR;
import com.objectriver.runtime.webrpc.xdr.XdrThing;
import com.objectriver.runtime.webrpc.xdr.marshals.XdrMarshal;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

public class xdr_int
extends XdrMarshal {
    public static xdr_int instance = new xdr_int();

    private xdr_int() {
    }

    @Override
    public boolean execute(XDR xdrs, XdrThing thing) throws WebRpcMarshallingException {
        try {
            if (xdrs.x_op == XDR.op.XDR_ENCODE) {
                Integer nt = (Integer)thing.getThing();
                if (nt == null) {
                    throw new WebRpcMarshallingException("xdr_int() int type can not be null! try defining as Integer.");
                }
                xdrs.put_int(nt);
                return true;
            }
            if (xdrs.x_op == XDR.op.XDR_DECODE) {
                thing.setThing(xdrs.get_int());
                return true;
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("xdr_int", ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("xdr_int", ex);
        }
        return xdrs.x_op == XDR.op.XDR_FREE;
    }

    @Override
    public Class getClazz() {
        return Integer.class;
    }
}

