/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.webrpc.xdr.marshals;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.xdr.XDR;
import com.objectriver.runtime.webrpc.xdr.XdrThing;
import com.objectriver.runtime.webrpc.xdr.marshals.XdrMarshal;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

public class xdr_short
extends XdrMarshal {
    public static xdr_short instance = new xdr_short();

    private xdr_short() {
    }

    @Override
    public boolean execute(XDR xdrs, XdrThing thing) throws WebRpcMarshallingException {
        try {
            if (xdrs.x_op == XDR.op.XDR_ENCODE) {
                Short shrt = (Short)thing.getThing();
                if (shrt == null) {
                    throw new WebRpcMarshallingException("xdr_short() short type can not be null! try defining as Short.");
                }
                xdrs.put_int(shrt.intValue());
                return true;
            }
            if (xdrs.x_op == XDR.op.XDR_DECODE) {
                Integer integer = xdrs.get_int();
                thing.setThing(integer.shortValue());
                return true;
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("xdr_short", ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("xdr_short", ex);
        }
        return xdrs.x_op == XDR.op.XDR_FREE;
    }

    @Override
    public Class getClazz() {
        return Short.class;
    }
}

