/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.webrpc.xdr.marshals;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.xdr.XDR;
import com.objectriver.runtime.webrpc.xdr.XdrThing;
import com.objectriver.runtime.webrpc.xdr.marshals.XdrMarshal;
import com.objectriver.runtime.webrpc.xdr.marshals.xdr_int;
import java.io.UnsupportedEncodingException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

public class xdr_string
extends XdrMarshal {
    public static xdr_string instance = new xdr_string();

    private xdr_string() {
    }

    public boolean execute(XDR xdrs, XdrThing thing, boolean notnull) throws WebRpcMarshallingException {
        if (notnull && xdrs.x_op == XDR.op.XDR_ENCODE && thing.isNull()) {
            throw new WebRpcMarshallingException("xdr_string() string type can not be null! try defining as String.");
        }
        return this.execute(xdrs, thing);
    }

    @Override
    public boolean execute(XDR xdrs, XdrThing thing) throws WebRpcMarshallingException {
        Integer size = 0;
        String string = null;
        try {
            XdrThing thing2;
            if (xdrs.x_op == XDR.op.XDR_ENCODE) {
                string = (String)thing.getThing();
                size = string == null ? 0 : string.length();
            }
            if (!xdr_int.instance.execute(xdrs, thing2 = new XdrThing(size))) {
                return false;
            }
            size = (Integer)thing2.getThing();
            switch (xdrs.x_op) {
                case XDR_DECODE: {
                    if (size == 0) {
                        thing.setThing("");
                        return true;
                    }
                    byte[] bytes = new byte[size.intValue()];
                    if (this.xdr_opaque(xdrs, bytes, size)) {
                        String decoded = new String(bytes, "UTF-8");
                        thing.setThing(decoded);
                        return true;
                    }
                    return false;
                }
                case XDR_ENCODE: {
                    if (size == 0) {
                        return true;
                    }
                    return this.xdr_opaque(xdrs, string.getBytes(), size);
                }
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new WebRpcMarshallingException("xdr_string", ex);
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("xdr_string", ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("xdr_string", ex);
        }
        return false;
    }

    @Override
    public Class getClazz() {
        return String.class;
    }
}

