/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.webrpc.xdr.marshals;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.xdr.XDR;
import com.objectriver.runtime.webrpc.xdr.XdrThing;
import com.objectriver.runtime.webrpc.xdr.marshals.XdrMarshal;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.sql.Timestamp;

public class xdr_timestamp
extends XdrMarshal {
    public static xdr_timestamp instance = new xdr_timestamp();

    @Override
    public boolean execute(XDR xdrs, XdrThing thing) throws WebRpcMarshallingException {
        try {
            if (xdrs.x_op == XDR.op.XDR_ENCODE) {
                Timestamp ts = (Timestamp)thing.getThing();
                if (ts == null) {
                    throw new WebRpcMarshallingException("xdr_timestamp() timestamp type can not be null! try defining as TimeStamp.");
                }
                xdrs.put_long(ts.getTime());
                return true;
            }
            if (xdrs.x_op == XDR.op.XDR_DECODE) {
                thing.setThing(xdrs.get_long());
                long time = (Long)thing.getThing();
                Timestamp ts = new Timestamp(time);
                thing.setThing(ts);
                return true;
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("xdr_timestamp", ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("xdr_timestamp", ex);
        }
        return false;
    }

    @Override
    public Class getClazz() {
        return Timestamp.class;
    }
}

