/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.webrpc.xdr;

import com.objectriver.runtime.util.asserts.Assert;
import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.xdr.XDR;
import com.objectriver.runtime.webrpc.xdr.XdrThing;
import com.objectriver.runtime.webrpc.xdr.marshals.xdr_float;
import com.objectriver.runtime.webrpc.xdr.marshals.xdr_int;
import com.objectriver.runtime.webrpc.xdr.marshals.xdr_nullable;
import com.objectriver.runtime.webrpc.xdr.marshals.xdr_string;
import java.nio.ByteBuffer;

public class testXdr {
    public static void main(String[] args) {
        ByteBuffer bb = ByteBuffer.allocate(5120);
        XDR xdrs = new XDR(bb, XDR.op.XDR_ENCODE);
        try {
            Integer intbefore = 1234;
            XdrThing thing = new XdrThing(intbefore);
            xdr_int.instance.execute(xdrs, thing);
            thing.setThing("chester");
            xdr_string.instance.execute(xdrs, thing);
            Float f = Float.valueOf(1234.5677f);
            thing.setThing(f);
            xdr_float.instance.execute(xdrs, thing);
            thing.setThing(null);
            xdr_string.instance.execute(xdrs, thing);
            xdr_int.instance.xdr_pointer(xdrs, thing.setThing(intbefore), xdr_int.instance);
            xdr_int.instance.xdr_pointer(xdrs, thing.setThing(null), xdr_int.instance);
            String[] strarray = new String[]{"1", "fred", "3"};
            xdr_string.instance.xdr_array(xdrs, thing.setThing(strarray), Integer.MAX_VALUE, xdr_string.instance);
            String[] strvector = new String[]{"fred", null, "ralph"};
            xdr_string.instance.xdr_vector(xdrs, thing.setThing(strvector), 3, new xdr_nullable(xdr_string.instance));
            Integer[] intvector = new Integer[]{1, 2, 3};
            xdr_string.instance.xdr_vector(xdrs, thing.setThing(intvector), 3, xdr_int.instance);
            Integer[] Intvector = new Integer[]{new Integer(1), null, new Integer(3)};
            xdr_string.instance.xdr_vector(xdrs, thing.setThing(Intvector), 3, new xdr_nullable(xdr_int.instance));
            bb.rewind();
            xdrs = new XDR(bb, XDR.op.XDR_DECODE);
            XdrThing thing2 = new XdrThing();
            xdr_int.instance.execute(xdrs, thing2);
            Assert.assertTrue("Integer failed", intbefore.equals(thing2.getThing()));
            xdr_string.instance.execute(xdrs, thing2);
            Assert.assertTrue("String failed", "chester".equals(thing2.getThing()));
            xdr_float.instance.execute(xdrs, thing2);
            Assert.assertTrue("String failed", f.equals(thing2.getThing()));
            xdr_string.instance.execute(xdrs, thing2);
            Assert.assertTrue("String failed", thing2.getThing() == null);
            xdr_int.instance.xdr_pointer(xdrs, thing2.setThing(null), xdr_int.instance);
            Assert.assertTrue("Integer failed", intbefore.equals(thing2.getThing()));
            xdr_int.instance.xdr_pointer(xdrs, thing2.setThing(null), xdr_int.instance);
            Assert.assertTrue("Integer failed", thing2.getThing() == null);
            xdr_int.instance.xdr_array(xdrs, thing2.setThing(null), Integer.MAX_VALUE, xdr_string.instance);
            String[] array = (String[])thing2.getThing();
            Assert.assertTrue("Integer failed", array[0].equals("1"));
            Assert.assertTrue("Integer failed", array[1].equals("fred"));
            Assert.assertTrue("Integer failed", array[2].equals("3"));
            xdr_int.instance.xdr_vector(xdrs, thing2.setThing(null), 3, xdr_string.instance);
            String[] vector = (String[])thing2.getThing();
            Assert.assertTrue("Integer failed", vector[0].equals("fred"));
            Assert.assertTrue("Integer failed", vector[1] == null);
            Assert.assertTrue("Integer failed", vector[2].equals("ralph"));
            xdr_int.instance.xdr_vector(xdrs, thing2.setThing(null), 3, xdr_int.instance);
            Integer[] ivector = (Integer[])thing2.getThing();
            Assert.assertTrue("Integer failed", ivector[0] == 1);
            Assert.assertTrue("Integer failed", ivector[1] == 2);
            Assert.assertTrue("Integer failed", ivector[2] == 3);
            xdr_string.instance.xdr_vector(xdrs, thing2.setThing(null), 3, new xdr_nullable(xdr_int.instance));
            Integer[] Ivector = (Integer[])thing2.getThing();
            Assert.assertTrue("Integer failed", Ivector[0] == 1);
            Assert.assertTrue("Integer failed", Ivector[1] == null);
            Assert.assertTrue("Integer failed", Ivector[2] == 3);
        }
        catch (WebRpcMarshallingException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
    }
}

