/*
 * Decompiled with CFR 0.152.
 */
package com.sun.misc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;

    public static byte[] readExactlyNBytes(InputStream is, int length) throws IOException {
        if (length < 0) {
            throw new IOException("length cannot be negative: " + length);
        }
        byte[] data = IOUtils.readNBytes(is, length);
        if (data.length < length) {
            throw new EOFException();
        }
        return data;
    }

    public static byte[] readAllBytes(InputStream is) throws IOException {
        return IOUtils.readNBytes(is, Integer.MAX_VALUE);
    }

    public static byte[] readNBytes(InputStream is, int len) throws IOException {
        int n;
        if (len < 0) {
            throw new IllegalArgumentException("len < 0");
        }
        ArrayList<byte[]> bufs = null;
        byte[] result = null;
        int total = 0;
        int remaining = len;
        do {
            byte[] buf = new byte[Math.min(remaining, 8192)];
            int nread = 0;
            while ((n = is.read(buf, nread, Math.min(buf.length - nread, remaining))) > 0) {
                nread += n;
                remaining -= n;
            }
            if (nread <= 0) continue;
            if (0x7FFFFFF7 - total < nread) {
                throw new OutOfMemoryError("Required array size too large");
            }
            total += nread;
            if (result == null) {
                result = buf;
                continue;
            }
            if (bufs == null) {
                bufs = new ArrayList<byte[]>();
                bufs.add(result);
            }
            bufs.add(buf);
        } while (n >= 0 && remaining > 0);
        if (bufs == null) {
            if (result == null) {
                return new byte[0];
            }
            return result.length == total ? result : Arrays.copyOf(result, total);
        }
        result = new byte[total];
        int offset = 0;
        remaining = total;
        for (byte[] b : bufs) {
            int count = Math.min(b.length, remaining);
            System.arraycopy(b, 0, result, offset, count);
            offset += count;
            remaining -= count;
        }
        return result;
    }

    public static int readNBytes(InputStream is, byte[] b, int off, int len) throws IOException {
        int n;
        int count;
        Objects.requireNonNull(b);
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        for (n = 0; n < len && (count = is.read(b, off + n, len - n)) >= 0; n += count) {
        }
        return n;
    }

    public static byte[] readFully(InputStream is, int length, boolean readAll) throws IOException {
        if (length < 0) {
            throw new IOException("length cannot be negative: " + length);
        }
        if (readAll) {
            return IOUtils.readExactlyNBytes(is, length);
        }
        return IOUtils.readNBytes(is, length);
    }
}

