package com.objectriver.microservices.rest;

import com.objectriver.microservices.things.RestDocument;

/**
 *                             NOTICE
 *               COPYRIGHT (c) 2016 ObjectRiver Inc
 *                UNPUBLISHED - ALL RIGHTS RESERVED
 */
public class RestException extends Exception {
    public Integer statusCode=0;
    public String trace=null;
    public RestException(String msg) {
        super(msg);
    }
    public RestException(String msg, Throwable cause) {
        super(msg,cause);
    }
    public RestException(RestDocument exceptionDoc) {
        super((String)exceptionDoc.getValue("message"));
        this.statusCode = (Integer)exceptionDoc.getValue("statusCode");
        this.trace = (String)exceptionDoc.getValue("trace");
    }
    public boolean hasTrace() { return trace!=null; }

    public int getStatusCode() { return statusCode; }
    public void setStatusCode(int statusCode) { this.statusCode = statusCode; }

    public String getTrace() { return trace; }
    public void setStackTrace(String stackTrace) { this.trace = stackTrace; }
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{')
            .append("\"message\":\"").append(this.getMessage()).append('"')
            .append("\"statusCode\":").append(statusCode);
        if(hasTrace()) sb.append("\"trace\":\"").append(trace).append('"');
        sb.append('}');
        return sb.toString();
    }
}
