package com.objectriver.microservices.things;
/**
 *                             NOTICE
 *             COPYRIGHT(c) 2016 ObjectRiver Inc.
 *                UNPUBLISHED - ALL RIGHTS RESERVED
 *
 *      This program is confidential, proprietary, and a trade
 *  secret of ObjectRiver Inc. The receipt or possession of
 *     this program does not convey any rights to reproduce or
 *      disclose its contents, or to manufacture, use, or sell
 *       anything that it may describe, in whole or in part,
 *  without the specific written consent of ObjectRiver Inc.
 *
 */
/**
 * The postit interface enables the attachment of arbitrary data
 * to an persistent.  The attached objects are maintained in a dictionary,
 * indexed by key strings.  This interface is implemented extensively
 * through the ObjectRiver runtime classes.
 */
public interface PostIt {
	/** Attach an persistent.
	 * 
	 * @param key Lookup string for posted persistent.
	 * @param obj Posted persistent.
	 */
    public void postIt(String key, Object obj);
    /** Retrieve an persistent by name.
     * 
     * @param key Lookup string for the posted persistent.
     * @return Previously posted persistent, or null if no persistent is posted
     * with the given key.
     */
    public Object postItRead(String key);
    /** Remove a posted persistent
     * 
     * @param key Lookup string for the posted persistent.
     */
    public void postItDiscard(String key);
    /** Check if a key is in use.
     * 
     * @param key Lookup string for the posted persistent.
     * @return True if the key string has a posted persistent.  False otherwise.
     */
    public boolean isPosted(String key);
}
