package com.objectriver.microservices.things;

import java.math.BigDecimal;
import java.util.List;
import com.objectriver.microservices.things.abstracts.RestThing;

/**
 *                             NOTICE
 *               COPYRIGHT (c) 2016 ObjectRiver Inc
 *                UNPUBLISHED - ALL RIGHTS RESERVED
 */
public enum RestThingType {
    Boolean(0),
    Integer(1),
    Long(11),
    Short(12),
    Double(25),
    Decimal(2),
    String(3),
    Date(4),
    Timestamp(5),
    Character(6),
    Byte(7),
    Clob(8),
    Blob(9),
    /* things */
    Object(20),
    Document(21),
    List(22),
    Dictionary(25),
    Enumeration(23),

    Null(98),
    BigDecimal(24),
    Unknown(99);

    public final int intValue;
    RestThingType(int value) {
        this.intValue = value;
    }
    public static RestThingType valueOf(Object value) {
        if(value == null)
            return RestThingType.Null;
        if(value instanceof String) {
            String str = (String)value;
            if(str.endsWith("Z") && str.matches("\\d\\d\\d\\d[-]\\d\\d[-]\\d\\d[T]\\d\\d[:]\\d\\d[:]\\d\\d\\.\\d\\d\\d[Z]")) {
                if(str.endsWith("00:00:00.000Z"))  return Date;
                else return Timestamp;
            }
            return RestThingType.String;
        }
        if(value instanceof RestThing)
            return ((RestThing)value).getType();
        if(value instanceof Integer)
            return RestThingType.Integer;
        if(value instanceof Long)
            return RestThingType.Long;
        if(value instanceof Short)
            return RestThingType.Short;
        if(value instanceof BigDecimal)
            return RestThingType.BigDecimal;
        if(value instanceof Boolean)
            return RestThingType.Boolean;
        if(value instanceof Float || value instanceof Double)
            return RestThingType.Decimal;
        if(value instanceof java.sql.Timestamp)
            return RestThingType.Timestamp;
        if(value instanceof java.sql.Date | value instanceof java.util.Date)
            return RestThingType.Date;
        if(value instanceof Character)
            return RestThingType.Character;
        if(value instanceof Byte)
            return RestThingType.Byte;
        if(value instanceof Enum)
            return RestThingType.Enumeration;
        if(value instanceof List)
            return RestThingType.List;
        return Unknown;
    }

    public static void main(String[] args) {
        System.out.println(Clob.toString());
    }
}
