package com.objectriver.microservices.things;
/**
 *                             NOTICE
 *               COPYRIGHT (c) 2016 ObjectRiver Inc
 *                UNPUBLISHED - ALL RIGHTS RESERVED
 */

import com.objectriver.microservices.things.abstracts.RestThing;

/**
 * Things generally belong to exactly one object hierarchy.
 * The Thing interface provides basic methods for navigating
 * this object hierarchy. 
 * <p>
 * Implementations should extend RestThing.
 *
 */
public interface Thing extends PostIt {
	/** The identifier is the type name used in the model
	 * for this Thing.
	 * @return identifier associated with the class.
	 */
    public String getIdentifier();
    public RestThingType getType();
    /** Return which type of thing -- Component, Persistent, Row, etc.
     * a thing belongs to.  
     * @return type of thing -- Component, Persistent, etc.
     */
    public RestThing getParent(Class clazz);
    /**  get the parent of this thing.
     * 
     * @return the parent, or null if Thing is the top or only object
     * in its object hierarchy
     */
    public RestThing getParent();
    /** set the parent of this object 
     * */
    public void setParent(RestThing p);
}
