package com.objectriver.microservices.util;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

/**
 *                             NOTICE
 *               COPYRIGHT (c) 2016 ObjectRiver Inc
 *                UNPUBLISHED - ALL RIGHTS RESERVED
 */
public class ISO8601DateTimeSingleton {
    static private DateFormat timestampformat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    static private DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd'T'00:00:00.000'Z'");
    static private ISO8601DateTimeSingleton instance = new ISO8601DateTimeSingleton();
    private ISO8601DateTimeSingleton() {};
    public static ISO8601DateTimeSingleton getInstance() {
        return instance;
    }
    public String getIsoDate(Date date) {
        String isodate;
        synchronized (dateformat) {
            isodate = dateformat.format(date);
        }
        return isodate;
    }
    public String getIsoDate(Timestamp ts) {
        String isots;
        synchronized (timestampformat) {
            isots = timestampformat.format(ts);
        }
        return isots;
    }
    public <T extends java.util.Date> T parseDateTime(T datetype, String isodate) throws java.text.ParseException {
        java.util.Date utilDate;
        synchronized (timestampformat) {
            utilDate = timestampformat.parse(isodate);
        }
        datetype.setTime(utilDate.getTime());
        return datetype;
    }
    public static void main(String[] agrs) {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        Date date = new Date(System.currentTimeMillis());
        System.out.println(ISO8601DateTimeSingleton.getInstance().getIsoDate(date));
        System.out.println(ISO8601DateTimeSingleton.getInstance().getIsoDate(ts));
        try {
            System.out.println(ISO8601DateTimeSingleton.instance.parseDateTime(date, ISO8601DateTimeSingleton.getInstance().getIsoDate(ts)));
            System.out.println(ISO8601DateTimeSingleton.instance.parseDateTime(ts, ISO8601DateTimeSingleton.getInstance().getIsoDate(ts)));
        }
        catch(java.text.ParseException ex) {
            System.err.println(ex.getMessage());
        }
    }
}
