package com.objectriver.microservices.things;

import com.objectriver.microservices.things.abstracts.RestScope;
import com.objectriver.microservices.things.json.abstracts.RestThingVisitor;

import java.util.ArrayList;
import java.util.List;

/**
 *                             NOTICE
 *               COPYRIGHT (c) 2016 ObjectRiver Inc
 *                UNPUBLISHED - ALL RIGHTS RESERVED
 */
public class RestDocument extends RestScope {
    public RestDocument() {
        super("document", RestThingType.Document);
    }
    @Override
    public boolean acceptVisit(Visitor visitor, boolean descend) {
        RestThingVisitor v = (RestThingVisitor) visitor;
        descend = v.beginVisitOfRestDocument(this);
        if (descend) {
            descend &= super.acceptVisit(visitor, descend);
        }
        v.endVisitOfRestDocument(this);
        return descend;
    }

    public Object get(Enum e) {
        /** Not Concrete RestObject class. */
        assert(false);
        return null;
    }

    public List<RestMember> getMembers() {
        /** Not Concrete RestObject class. */
        List<RestMember> list = new ArrayList<>();
        for(String member : memberList ) {
            RestMember value = get(member);
            list.add(value);
        }
        return list;
    }
}