package com.objectriver.microservices.things;

import com.objectriver.microservices.things.abstracts.RestThing;
import com.objectriver.microservices.things.json.abstracts.RestThingVisitor;

import java.util.*;

/**
 *                             NOTICE
 *               COPYRIGHT (c) 2016 ObjectRiver Inc
 *                UNPUBLISHED - ALL RIGHTS RESERVED
 */
public class RestList<T> extends RestThing implements List<T>, Thing, Visit {
    protected List<T> list;
    protected RestThingType ofType;
    public RestList(String identifier, RestThingType ofType, RestThing parent) {
        super(identifier, RestThingType.List,parent);
        this.list = new ArrayList<T>();
        this.ofType = ofType;
    }
    public RestList(String identifier, RestThingType ofType) {
        super(identifier, RestThingType.List);
        this.list = new ArrayList<T>();
        this.ofType = ofType;
    }
    public RestList(String identifier) {
        super(identifier, RestThingType.List);
        this.list = new ArrayList<T>();
        this.ofType = RestThingType.Unknown;
    }

    public RestThingType getOfType() {
        return ofType;
    }
    public void setOfType(RestThingType ofType) {
        this.ofType = ofType;
    }

    public boolean acceptVisit(Visitor visitor, boolean descend) {
        RestThingVisitor v = (RestThingVisitor)visitor;
        descend = v.beginVisitOfRestList(this);
        if(descend) {
            Iterator<T> iter = list.iterator();
            while(iter.hasNext()) {
                T item = iter.next();
                switch(ofType) {
                case Object:
                case List: {
                    RestThing thing = (RestThing)item;
                    thing.visit(v);
                    break;
                }
                default: {
                    RestMember member = new RestMember("member",ofType,item,this);
                    member.acceptVisit(visitor, descend);
                }
                }
            }
        }
        v.endVisitOfRestList(this);
        return descend;
    }
    /** List implementation */
    @Override public int size() {
        return list.size();
    }
    @Override public boolean isEmpty() {
        return list.isEmpty();
    }
    @Override public boolean contains(Object o) {
        return list.contains(o);
    }
    @Override public Iterator<T> iterator() {
        return list.iterator();
    }
    @Override public Object[] toArray() {
        return list.toArray();
    }
    @Override public <T1> T1[] toArray(T1[] a) {
        return list.toArray(a);
    }
    @Override public boolean add(T t) {
        if(ofType==RestThingType.Unknown) {
            ofType=RestThingType.valueOf(t);
        }
        if(t instanceof Thing) {
            ((Thing)t).setParent(this);
        }
        return list.add(t);
    }
    @Override public boolean remove(Object o) {
        return list.remove(o);
    }
    @Override public boolean containsAll(Collection<?> c) {
        return list.containsAll(c);
    }
    @Override public boolean addAll(Collection<? extends T> c) {
        if(!c.isEmpty()) {
            Object obj = c.iterator().next();
            if(ofType==RestThingType.Unknown) {
                ofType=RestThingType.valueOf(obj);
            }
            if(obj instanceof RestThing) {
                RestThing thing1 = (RestThing) obj;
                if(thing1.getParent()==null) {
                    for(Object thing2 : c) {
                        ((RestThing)thing2).setParent(this);
                    }
                }
            }
        }
        return list.addAll(c);
    }
    @Override public boolean addAll(int index, Collection<? extends T> c) {
        return list.addAll(index,c);
    }
    @Override public boolean removeAll(Collection<?> c) {
        return list.removeAll(c);
    }
    @Override public boolean retainAll(Collection<?> c) {
        return list.retainAll(c);
    }
    @Override public void clear() {
        list.clear();
    }
    @Override public T get(int index) {
        return list.get(index);
    }
    @Override public T set(int index, T element) {
        return list.set(index,element);
    }
    @Override public void add(int index, T element) {
        list.add(index,element);
    }
    @Override public T remove(int index) {
        return list.remove(index);
    }
    @Override public int indexOf(Object o) {
        return list.indexOf(o);
    }
    @Override public int lastIndexOf(Object o) {
        return list.lastIndexOf(o);
    }
    @Override public ListIterator<T> listIterator() {
        return list.listIterator();
    }
    @Override public ListIterator<T> listIterator(int index) {
        return list.listIterator(index);
    }
    @Override public List<T> subList(int fromIndex, int toIndex) {
        return list.subList(fromIndex,toIndex);
    }
}
