package com.objectriver.microservices.things;

import com.objectriver.microservices.things.abstracts.RestThing;
import com.objectriver.microservices.things.json.abstracts.RestThingVisitor;
import com.objectriver.microservices.util.ISO8601DateTimeSingleton;

import java.sql.Date;
import java.sql.Timestamp;

/**
 *                             NOTICE
 *               COPYRIGHT (c) 2016 ObjectRiver Inc
 *                UNPUBLISHED - ALL RIGHTS RESERVED
 */
public class RestMember extends RestThing {
    public RestMember(String identifier, RestThingType type, Object value, RestThing parent) {
        super(identifier,type,parent);
        switch(type) {
        case Timestamp:
            try {
                if (value instanceof String) {
                    this.value = ISO8601DateTimeSingleton.getInstance().parseDateTime(new Timestamp(System.currentTimeMillis()), (String) value);
                    return;
                }
            }
            catch(java.text.ParseException ex) {}
            break;
        case Date:
            try {
                if (value instanceof String) {
                    this.value = ISO8601DateTimeSingleton.getInstance().parseDateTime(new Date(System.currentTimeMillis()), (String) value);
                    return;
                }
            }
            catch(java.text.ParseException ex) {}
            break;
//        case List:
//            try {
//                List list = (List)value;
//                if (!(value instanceof RestList)) {
//                    if(list.isEmpty()) {
//                        this.value = new RestList(identifier,RestThingType.Unknown, parent);
//                    }
//                    else {
//                        this.value = new RestList(identifier, RestThingType.valueOf(list.get(0)), parent);
//                        ((RestList) this.value).addAll(list);
//                    }
//                    return;
//                }
//            }
//            finally {}
//            break;
        default:
        }
        this.value = value;
    }
    protected Object value;
    public Object getValue() {
        return value;
    }
    public void setValue(Object value) {
        this.value = value;
    }

    public boolean acceptVisit(Visitor visitor, boolean descend) {
        RestThingVisitor v = (RestThingVisitor)visitor;
        descend = v.beginVisitOfRestMember(this);
        if(descend && this.getValue() instanceof Thing) {
            RestThing thing = (RestThing) this.getValue();
            thing.visit(v);
        }
        v.endVisitOfRestMember(this);
        return descend;
    }


}
