package com.objectriver.microservices.things;


import com.objectriver.microservices.things.abstracts.RestScope;
import com.objectriver.microservices.things.json.abstracts.RestThingVisitor;

import java.util.ArrayList;
import java.util.List;

/**
 *                             NOTICE
 *               COPYRIGHT (c) 2016 ObjectRiver Inc
 *                UNPUBLISHED - ALL RIGHTS RESERVED
 */
public class RestObject extends RestScope {
    public RestObject(String identifier) {
        super(identifier, RestThingType.Object);
    }

    public boolean acceptVisit(Visitor visitor, boolean descend) {
        RestThingVisitor v = (RestThingVisitor)visitor;
        descend = v.beginVisitOfRestObject(this);
        if(descend) {
            descend &= super.acceptVisit(visitor, descend);
        }
        v.endVisitOfRestObject(this);
        return descend;
    }
    protected boolean concreteClass = false;
    public boolean isConcreteClass() { return concreteClass;}

    /**
     * abstract methods overwritten in bean__ class.
     */
    public /* abstract*/ void setValue(String key, Object value) {setMember(key,value);}
    public /* abstract*/ Object getValue(String key) { return getMember(key); }

    public void setMember(String key, Object value) {
        super.put(key,value); //transient
    }
    public Object getMember(String key) {
        RestMember member =  super.get(key);
        return (member==null) ? null : member.getValue();
    }
    public List<RestMember> getMembers() {
        /** Not Concrete RestObject class. */
        List<RestMember> list = new ArrayList<>();
        for(String member : memberList ) {
            RestMember value = get(member);
            list.add(value);
        }
        return list;
    }
}
