package com.objectriver.microservices.things;

import java.math.BigDecimal;
import java.util.List;
import com.objectriver.microservices.things.abstracts.RestThing;
import com.objectriver.microservices.util.ISO8601DateTimeSingleton;

/**
 *                             NOTICE
 *               COPYRIGHT (c) 2016 ObjectRiver Inc
 *                UNPUBLISHED - ALL RIGHTS RESERVED
 */
public enum RestThingType {
    Boolean(0),
    Integer(1),
    Long(11),
    Short(12),
    Double(35),
    Float(36),
    Decimal(2),
    String(3),
    Date(4),
    Timestamp(5),
    Character(6),
    Byte(7),
    Clob(8),
    Blob(9),
    /* things */
    Object(20),
    Document(21),
    List(22),
    Dictionary(25),
    Enumeration(23),

    Null(98),
    BigDecimal(24),
    Unknown(99);

    public final int intValue;
    RestThingType(int value) {
        this.intValue = value;
    }
    public static RestThingType valueOf(Object value) {
        if(value == null)
            return RestThingType.Null;
        if(value instanceof String) {
            String str = (String)value;
            if(str.length()>9 &&
                    java.lang.Character.isDigit(str.charAt(0)) &&
                    java.lang.Character.isDigit(str.charAt(1)) &&
                    java.lang.Character.isDigit(str.charAt(2)) &&
                    java.lang.Character.isDigit(str.charAt(3)) &&
                    str.charAt(4)=='-' &&
                    java.lang.Character.isDigit(str.charAt(5)) &&
                    java.lang.Character.isDigit(str.charAt(6)) &&
                    str.charAt(7)=='-' &&
                    java.lang.Character.isDigit(str.charAt(8)) &&
                    java.lang.Character.isDigit(str.charAt(9))
                    ) {
                if(str.length()==10) {
                    return Date;
                }
                java.sql.Timestamp instance = new java.sql.Timestamp(System.currentTimeMillis());
                try {
                    java.sql.Timestamp ts = ISO8601DateTimeSingleton.getInstance().parseDateTime(instance, str);
                    return Timestamp;
                }
                catch(java.text.ParseException ex){}
            }
            return RestThingType.String;
        }
        if(value instanceof RestThing)
            return ((RestThing)value).getRestThingType();
        if(value instanceof Integer)
            return RestThingType.Integer;
        if(value instanceof Long)
            return RestThingType.Long;
        if(value instanceof Short)
            return RestThingType.Short;
        if(value instanceof BigDecimal)
            return RestThingType.BigDecimal;
        if(value instanceof Boolean)
            return RestThingType.Boolean;
        if(value instanceof Float || value instanceof Double)
            return RestThingType.Decimal;
        if(value instanceof java.sql.Timestamp)
            return RestThingType.Timestamp;
        if(value instanceof java.sql.Date | value instanceof java.util.Date)
            return RestThingType.Date;
        if(value instanceof Character)
            return RestThingType.Character;
        if(value instanceof Byte)
            return RestThingType.Byte;
        if(value instanceof Enum)
            return RestThingType.Enumeration;
        if(value instanceof List)
            return RestThingType.List;
        return Unknown;
    }

    public static void main(String[] args) {
        System.out.println(Clob.toString());
    }
}
