package com.objectriver.microservices.things;
/**
 *                             NOTICE
 *               COPYRIGHT (c) 2016 ObjectRiver Inc
 *                UNPUBLISHED - ALL RIGHTS RESERVED
 */
/**
 * Interface implemented to enable visitation.
 * This is a very simple interface which is heavily used within the
 * Objectriver runtime as well as ObjectRiver applications.
 * <p>
 * This interface is implemented by the runtime Thing classes and also
 * by the generated abstact classes.  It is not intended to be implemented
 * by the application.
 * <p>
 * Visitation is used to process the object hierarchies that are
 * instances of the Persistent and Component classes of the model.
 * <p>
 * The application uses the Visitor pattern by creating an implementation
 * of the runtime Visitor classes.
 * Typically the implementation will use one of the generated extension classes.
 * <p>
 * An instance of the Visitor class will be passed to the visit method of a  
 * Persistent or Component to visit the object.
 * 
 */
public interface Visit {
    /** Visitor support */
    public void visit(Visitor visitor);
}
