package com.objectriver.microservices.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class RestProperties {
    /**
     * This routine loads properties within the jar file
     */
    public static Properties getProperties(String fileName) throws RuntimeException {
        try {
            // load the properties file from the top of the class path
            Properties restProperties = new Properties();
            InputStream stream = ClassLoader.getSystemResourceAsStream(fileName);
            restProperties.load(stream);
            stream.close();
            return restProperties;
        } catch (FileNotFoundException fnfe) {
            throw new RuntimeException("Properties file " +  fileName + " file not found", fnfe);
        } catch (IOException ioe) {
            throw new RuntimeException("Properties file " +  fileName + "IOException", ioe);
        }
    }
}
