package com.companyname.simplebeans;

/**
 * IOT (Internet Of Things Server.
 * This server is build with Grizzly NIO/ Jersey implementation, for non-webserver applications.
 * It can serve webservices as well as static web pages.
 * It can also be directly debuged in Intellij, Eclipse, and NetBeans.
 */
import com.companyname.simplebeans.simplebeaniface.server.servlet.*;

import com.objectriver.microservices.util.RestProperties;
import org.glassfish.grizzly.http.server.CLStaticHttpHandler;
import org.glassfish.grizzly.http.server.HttpHandlerRegistration;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.servlet.FilterRegistration;
import org.glassfish.grizzly.servlet.WebappContext;
import org.glassfish.jersey.servlet.ServletContainer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;

import javax.servlet.DispatcherType;
import javax.servlet.ServletRegistration;
import java.io.File;
import java.io.IOException;
import java.net.*;
import java.util.EnumSet;
import java.util.Properties;

/**
 * Jersey Grizzly Server
 */
public class SimpleBeans_IotWebServer {
    /**
     * Starts Grizzly HTTP server exposing JAX-RS resources defined in this application.
     * @return Grizzly HTTP server.
     */
    public static void main(String[] args) throws IOException {
        Properties restProps = RestProperties.getProperties("restframework.properties");
        final String protocol = "http://";
        final String host = restProps.getProperty("rest.host");
        final String webapp = "SimpleBeans";
        final String ui = "UI";
        final String port = restProps.getProperty("rest.port");
        startServer(protocol, host, webapp, ui, port);
    }


    public static void startServer(String protocol, String host, String webapp, String ui, String port) {
        try {
            String BASE_URI = protocol + host + ":" + port + "/" + webapp + "/";
            /**
             * Create and start a new instance of grizzly http server
             * exposing the Jersey application at BASE_URI
             */
            HttpServer httpServer = GrizzlyHttpServerFactory.createHttpServer(URI.create(BASE_URI));

            /*--- Static Content ---*/
            if(ui!=null && !ui.equals("")) {
                URL jarPath = getJarPath(SimpleBeans_IotWebServer.class);
                if (jarPath != null) {
                    CLStaticHttpHandler clStaticHttpHandler = new CLStaticHttpHandler(
                            new URLClassLoader(new URL[]{jarPath}),
                            "/", "/"+ui+"/"); // ui is a context and rootDoc depending on application setup
                    ServerConfiguration sc = httpServer.getServerConfiguration();
                    sc.addHttpHandler(clStaticHttpHandler, HttpHandlerRegistration.builder().contextPath("/" + webapp + "/" + ui + "").urlPattern("").build());
                }
            }

            /*--- SimpleBeanIface WebappContext ---*/
            WebappContext SimpleBeanIfaceContext = new WebappContext("SimpleBeanIfaceWebappContext", "/" + webapp + "/" + "SimpleBeanIface");

            /*--- Listeners ---*/
            SimpleBeanIfaceContext.addListener("com.companyname.simplebeans.simplebeaniface.server.servlet.SimpleBeanIfaceListener");

            /*--- Filters ---*/
            FilterRegistration simpleBeanIfaceFilterRegistration = SimpleBeanIfaceContext.addFilter("SimpleBeanIfaceFilter", SimpleBeanIfaceFilter.class);
            simpleBeanIfaceFilterRegistration.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST),"/SimpleBeanIface/*");

            /*--- Servlet ---*/
            final ResourceConfig simpleBeanIfaceRc = new SimpleBeanIfaceApplication();
            ServletRegistration simpleBeanIfaceRegistration = SimpleBeanIfaceContext.addServlet("ServletContainer", new ServletContainer(simpleBeanIfaceRc));
            simpleBeanIfaceRegistration.addMapping("/*");

            /**
             * Deploy Server
             */
            SimpleBeanIfaceContext.deploy(httpServer);

            /**
             * Start Server
             */
            httpServer.start();

            System.out.println("Jersey app started with WADL available at:");
            System.out.println(BASE_URI + "SimpleBeanIface/application.wdl");
            System.out.println("Hit enter to stop it...");
            System.in.read();
            httpServer.shutdown();
        }
        catch(Exception ex) {
           System.err.println("Error: " + ex.getMessage());
        }
    }
    public static URL getJarPath(Class clazz) {
        try {
            URI jarPath = clazz.getProtectionDomain().getCodeSource().getLocation().toURI();
            return jarPath.toURL();
        }
        catch(URISyntaxException ex) {}
        catch(MalformedURLException ex) {}
        return null;
    }
}
