package com.companyname.simplebeans.common.visitors;

import com.companyname.simplebeans.common.SimpleBeansThingVisitor;
import com.companyname.simplebeans.simplebeaniface.common.beans.Simple;

import com.objectriver.microservices.rest.RestException;
import com.objectriver.microservices.things.RestList;
import com.objectriver.microservices.things.RestMember;
import com.objectriver.microservices.things.RestObject;
import com.objectriver.microservices.things.abstracts.RestScope;
import com.objectriver.microservices.util.ISO8601DateTimeSingleton;


/**
 *                             NOTICE
 *             COPYRIGHT(c) 2016 ObjectRiver, Inc.
 *                UNPUBLISHED - ALL RIGHTS RESERVED
 *
 *      This program is confidential, proprietary, and a trade
 *  secret of ObjectRiver, Inc. The receipt or possession of
 *     this program does not convey any rights to reproduce or
 *      disclose its contents, or to manufacture, use, or sell
 *       anything that it may describe, in whole or in part,
 *  without the specific written consent of ObjectRiver, Inc.
 *
 */
public class SimpleBeansFixupVisitor extends SimpleBeansThingVisitor {
    private SimpleBeansFixupVisitor(){}
    /**
     * This method is used when Json decodes directly into the concrete object.
     */
    public static <C extends RestObject> C execute(C concrete) throws RestException {
        if(!concrete.isConcreteClass())
            throw new RestException("Visitor object must be concrete class extends RestObject");
        concrete.visit(new SimpleBeansFixupVisitor());
        return concrete;
    }
    /**
     * This method is used when Json decodes RestList of concreate objects..
     */
    public static <C extends RestObject> RestList<C> execute(RestList<C> concreteList) throws RestException {
        if(!concreteList.isEmpty() && !((RestObject)concreteList.get(0)).isConcreteClass())
            throw new RestException("Visitor object must be concrete class extends RestObject");
        concreteList.visit(new SimpleBeansFixupVisitor());
        return concreteList;
    }
    /**
     * This method is used when Json decodes into a RestDocument or RestObject. The members
     * are copied from the scope to the concrete instnce before the visit.
     */
    public static <C extends RestObject> C execute(RestScope scope, C concrete) throws RestException {
        if(scope==null)
            return null;
        if(!concrete.isConcreteClass())
            throw new RestException("Visitor object must be concrete class extends RestObject");
        /**
         * Copy top level member from document to concrete RestObject.
         */
        for(RestMember member : scope.getMembers()) {
            concrete.put(member.getIdentifier(),member);
        }
        concrete.visit(new SimpleBeansFixupVisitor());
        return concrete;
    }
    public boolean beginVisitOfSimple(Simple value) {
        if(!value.isEmpty()) {
            value.setMyinteger(value.get(Simple.Members.myinteger.name()));
            value.setMytimestamp(value.get(Simple.Members.mytimestamp.name()));
            value.setMydate(value.get(Simple.Members.mydate.name()));
            value.setMydouble(value.get(Simple.Members.mydouble.name()));
            value.setMystring(value.get(Simple.Members.mystring.name()));
            value.setMythings(value.get(Simple.Members.mythings.name()));
        }
        return true;
    }
}
