package com.companyname.simplebeans.simplebeaniface.client;

import com.objectriver.microservices.rest.RestException;
import com.objectriver.microservices.rest.RestHttpClient;
import com.objectriver.microservices.things.RestList;
import com.objectriver.microservices.things.abstracts.RestScope;
import com.objectriver.microservices.things.abstracts.RestThing;
import com.objectriver.microservices.things.json.RestJsonParser;
import com.objectriver.microservices.platforms.sfdc.*;

import org.apache.http.*;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;

import javax.json.*;
import javax.net.ssl.*;
import java.io.*;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.*;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
/**
 *                             NOTICE
 *             COPYRIGHT(c) 2016 ObjectRiver, Inc.
 *                UNPUBLISHED - ALL RIGHTS RESERVED
 *
 *      This program is confidential, proprietary, and a trade
 *  secret of ObjectRiver, Inc. The receipt or possession of
 *     this program does not convey any rights to reproduce or
 *      disclose its contents, or to manufacture, use, or sell
 *       anything that it may describe, in whole or in part,
 *  without the specific written consent of ObjectRiver, Inc.
 *
 *  This class is generated from a createonce template, so it can be modified
 *  and will not be overwritten.
 *
 *  Example Java Server:
 *      URI simplebeanifaceUri  = new URI("http://localhost:9090/SimpleBeans/SimpleBeanIface/");
 *      simpleBeanIfaceClient = new SimpleBeanIfaceClient(simplebeanifaceUri);
 *
 *  Example SalesForce Server:
 *      SfdcKey applicationKey = new SimpleBeansSfdcKey(false); // get SfdcApplicationKey
 *      SfdcKeySingleton.instanceOf().set("fred@flintstones.com",applicationKey); // load into singleton
 *      URI restendpointUri  = new URI(applicationKey.getConnUrl()); // get connection url.
 *      simpleBeanIfaceClient = new SimpleBeanIfaceClient(simplebeanifaceUri, "fred@flintstones.com", "dino");
 *
 */
public class SimpleBeanIfaceClient extends SimpleBeanIfaceStub {
    public SimpleBeanIfaceClient(URI uri) throws RestException {
        super(uri);
        this.createHttpClient();
    }

    //BasicAuth & SalesForce
    public SimpleBeanIfaceClient(URI uri, String user, String password) throws RestException {
        super(uri,user,password);
        this.createHttpClient();
    }
    public SimpleBeanIfaceClient(String url) throws URISyntaxException, RestException {
            super(new URI(url)); // use for override.
    }

    /**
     * This constructor is needed when there are multiple endpoints defined in your model, and
     * you want to run them over the same session.
     * It can be used to make a copy of the client for another <endpoint>Client. After the
     * the copy call newClient.setEndpoint("endpoint") with the endpoint name that corresponds to
     * the new endpoint.
     */
    public SimpleBeanIfaceClient(RestHttpClient client) throws RestException {
        super(client);
        setEndpoint("SimpleBeanIface");
    }

    public HttpClient createHttpClient() throws RestException {
        SSLConnectionSocketFactory sslsf = null;
        /**
         * Do https of http.
         */
        boolean useSSL = (host.getSchemeName()==null) ? false : host.getSchemeName().equals("https");
        BasicCredentialsProvider creds = new BasicCredentialsProvider();
        if(this.user!=null && this.password!=null) {
            creds.setCredentials(new AuthScope(host.getHostName(), host.getPort()),
                    new UsernamePasswordCredentials(this.user, this.password));
        }

        this.requestConfig = RequestConfig.custom()
                .setConnectionRequestTimeout(15000)
                .setConnectTimeout(15000)
                .setSocketTimeout(15000)
                .build();
        if(useSSL) {
            SSLContext sslcontext = null;
            try {
                SSLContextBuilder builder = SSLContexts.custom();
                builder.loadTrustMaterial(null, new TrustStrategy() {
                    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        return true;
                    }
                });
                builder.useProtocol("TLSv1.1");
                sslcontext = builder.build();
            } catch (KeyManagementException e1) {
                e1.printStackTrace();
            } catch (NoSuchAlgorithmException e1) {
                e1.printStackTrace();
            } catch (KeyStoreException e1) {
                e1.printStackTrace();
            }
            sslsf = new SSLConnectionSocketFactory(
                    sslcontext, new HostnameVerifier() {
                @Override
                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            });
            RegistryBuilder<ConnectionSocketFactory> registryBuilder = RegistryBuilder.create();
            Registry<ConnectionSocketFactory> registry = registryBuilder.register("https", sslsf).build();
            HttpClientConnectionManager cm = new BasicHttpClientConnectionManager(registry);

            client = HttpClients.custom()
                    .setDefaultRequestConfig(requestConfig)
                    .setConnectionManager(cm)
                    .setDefaultCredentialsProvider(creds)
                    .setMaxConnPerRoute(10)
                    .setMaxConnTotal(1024)
                    .setSSLSocketFactory(sslsf)
                    .build();
            /**
             * Check for SalesForce endpoint.
             */
            if(host.getHostName().contains("salesforce"))
                return createSfdcHttpClient(user,password);
            return client;
        }

        client = HttpClients.custom()
                .setDefaultRequestConfig(requestConfig)
                .setConnectionManager(new BasicHttpClientConnectionManager())
                .setDefaultCredentialsProvider(creds)
                .setMaxConnPerRoute(10)
                .setMaxConnTotal(1024)
                .build();
        return client;
    }
    public HttpClient createSfdcHttpClient(String user, String password) throws RestException {
        try {
            SfdcKey sfdcKey = SfdcKeySingleton.instanceOf().get(user);
            if(sfdcKey==null) {
                throw new RestException("SfdcKey for user=" + user + " is not found?");
            }
            List<NameValuePair> params = new ArrayList<NameValuePair>();
            params.add(new BasicNameValuePair("client_id", sfdcKey.getConsumerKey()));
            params.add(new BasicNameValuePair("client_secret", sfdcKey.getConsumerSecret()));
            params.add(new BasicNameValuePair("grant_type", "password"));
            params.add(new BasicNameValuePair("username", user));
            params.add(new BasicNameValuePair("password", password + sfdcKey.getSfdcSecurityToken()));

            URIBuilder builder = new URIBuilder(sfdcKey.getConnUrl().toString());
            builder.setParameters(params);

            HttpPost httpPost = new HttpPost(builder.build());
            httpPost.setEntity(new UrlEncodedFormEntity(params));
            HttpResponse response = client.execute(httpPost);

            if (response.getStatusLine().getStatusCode() != 200) {
                System.out.println("StatusCode=" + response.getStatusLine().getStatusCode());
                System.out.println(response.getStatusLine().getReasonPhrase());
                System.exit(-1);
            }
            HttpEntity entity = response.getEntity();
            InputStream is = entity.getContent();
            InputStreamReader isr = new InputStreamReader(is);

            JsonReader jr = Json.createReader(isr);
            JsonObject jo = jr.readObject();
            String id=jo.getString("id");
            String issued_at=jo.getString("issued_at");
            String token_type=jo.getString("token_type");
            String instance_url=jo.getString("instance_url");
            String signature = jo.getString("signature");
            String access_token = jo.getString("access_token");
            jr.close();
            /**
             * Update client URI
             */
            try {
                String org = sfdcKey.getOrg();
                this.setUri(new URI(instance_url + "/services/apexrest/" + ((org==null) ? "" : org + "/") + "SimpleBeanIface" ));
            }
            catch(URISyntaxException ex){}
            /**
             * Add additional header to resulting web services.
             * results in --> httpGet.addHeader("Authorization", "Bearer " + access_token);
             */
            this.addHeader(new BasicHeader("Authorization", "Bearer " + access_token));
            this.setSalesforce(true);
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return client;
    }

    /**
     * Parses Json RestDocument or RestObject depending on type of T.
     */
    public <T extends RestScope> T parseJsonObject(T scope, HttpResponse response) throws RestJsonParser.RestJsonParserException {
        try {
            return new RestJsonParser(response.getEntity().getContent()).parseObject(scope);
        }
        catch(IOException ex) {
            throw new RestJsonParser.RestJsonParserException(ex);
        }
    }
    /**
     * Parses RestList<Bean> and passes concrete object Bean instance. This will return RestList of concrete objects.
     */
    public <T extends RestThing> RestList<T> parseJsonList(RestList<T> list, T instance, HttpResponse response) throws RestJsonParser.RestJsonParserException {
        try {
            return new RestJsonParser(response.getEntity().getContent()).parseList(list,instance);
        }
        catch(IOException ex) {
            throw new RestJsonParser.RestJsonParserException(ex);
        }
    }
    /**
     * Parses RestList<Primitive> list of primitives.
     */
    public <T> RestList<T> parseJsonList(RestList<T> list, HttpResponse response) throws RestJsonParser.RestJsonParserException {
        try {
            return new RestJsonParser(response.getEntity().getContent()).parseList(list);
        }
        catch(IOException ex) {
            throw new RestJsonParser.RestJsonParserException(ex);
        }
    }
    /**
     * close client.
     */
    public void close(HttpResponse response) {
        try {
            if(response!=null && response instanceof CloseableHttpResponse) {
                ((CloseableHttpResponse)response).close();
            }
        }
        catch(IOException ex) {}
    }
    public void close() {
        try {
            ((CloseableHttpClient) client).close();
        }
        catch(IOException ex) {}
    }
}
