package com.companyname.simplebeans.simplebeaniface.client;
/**
 *                             NOTICE
 *             COPYRIGHT(c) 2016 ObjectRiver, Inc.
 *                UNPUBLISHED - ALL RIGHTS RESERVED
 *
 *      This program is confidential, proprietary, and a trade
 *  secret of ObjectRiver, Inc. The receipt or possession of
 *     this program does not convey any rights to reproduce or
 *      disclose its contents, or to manufacture, use, or sell
 *       anything that it may describe, in whole or in part,
 *  without the specific written consent of ObjectRiver, Inc.
 *
 *  This <Inteface>FullStub wraps the <Interface>Client completely, whereas
 *  the <Interface>Stub returns the HttpResponse for more complicated Rest
 *  implementations.
 */

import com.companyname.simplebeans.simplebeaniface.common.beans.Simple;
import com.companyname.simplebeans.simplebeaniface.common.enums.*;
import com.companyname.simplebeans.common.*;
import com.companyname.simplebeans.common.visitors.SimpleBeansFixupVisitor;
import com.companyname.simplebeans.simplebeaniface.common.json.SimpleBeanIfaceJsonVisitor;

import com.objectriver.microservices.things.RestList;
import com.objectriver.microservices.rest.RestException;
import com.objectriver.microservices.things.RestDocument;
import com.objectriver.microservices.things.json.RestJsonParser;
import com.objectriver.microservices.util.RestNameValuePair;

import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpResponseException;

import java.io.*;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class SimpleBeanIfaceFullStub {
    protected final SimpleBeanIfaceClient simpleBeanIfaceClient;

    private SimpleBeanIfaceFullStub() {
        simpleBeanIfaceClient = null;
    }

    public SimpleBeanIfaceFullStub(SimpleBeanIfaceClient simpleBeanIfaceClient) {
        this.simpleBeanIfaceClient = simpleBeanIfaceClient;
    }

    public Simple simpleBeanTrip(Simple arg) throws HttpResponseException,SimpleBeanException {
        /**
        @Path("simpleBeanTrip")
        @Produces(JSON)
        @Consumes(JSON)
        @POST Simple simpleBeanTrip( @In Simple arg ) throws SimpleBeanException;
        */
        HttpResponse response = null;
        try {
            List<NameValuePair> params = new ArrayList<>();
            List<NameValuePair> headers = new ArrayList<>();

            /**
             * Execute
             */
            response = simpleBeanIfaceClient.simpleBeanTrip( arg, params, headers);
            if (response.getStatusLine().getStatusCode() == 200) {
                Simple result = simpleBeanIfaceClient.parseJsonObject(new Simple("result"), response);
                result = SimpleBeansFixupVisitor.execute(result);
                return result;
            }
            else if (response.getStatusLine().getStatusCode() == 420) { // Method Failure
                RestDocument fault = simpleBeanIfaceClient.parseJsonObject(new RestDocument(), response);
                throw new SimpleBeanException(fault);
            }
            else {
                throw new HttpResponseException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase());
            }
        }
        catch (RestJsonParser.RestJsonParserException ex) {
            throw new SimpleBeanException("RestException", ex);
        }
        catch (RestException ex) {
            throw new SimpleBeanException("RestException", ex);
        }
        finally {
            if (response != null) simpleBeanIfaceClient.close(response);
        }
    }

}
