package com.companyname.simplebeans.simplebeaniface.client;

import com.companyname.simplebeans.simplebeaniface.common.beans.Simple;
import com.companyname.simplebeans.simplebeaniface.common.enums.*;
import com.companyname.simplebeans.common.*;
import com.companyname.simplebeans.simplebeaniface.common.json.SimpleBeanIfaceJsonVisitor;

import com.objectriver.microservices.util.RestNameValuePair;
import com.objectriver.microservices.things.RestDocument;
import com.objectriver.microservices.things.json.RestJsonVisitor;
import com.objectriver.microservices.rest.RestException;
import com.objectriver.microservices.rest.RestHttpClient;

import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.*;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.sql.Date;
import java.util.List;

/**
 *                             NOTICE
 *             COPYRIGHT(c) 2016 ObjectRiver, Inc.
 *                UNPUBLISHED - ALL RIGHTS RESERVED
 *
 *      This program is confidential, proprietary, and a trade
 *  secret of ObjectRiver, Inc. The receipt or possession of
 *     this program does not convey any rights to reproduce or
 *      disclose its contents, or to manufacture, use, or sell
 *       anything that it may describe, in whole or in part,
 *  without the specific written consent of ObjectRiver, Inc.
 *
 */
public abstract class SimpleBeanIfaceStub extends RestHttpClient {
    protected RequestConfig requestConfig;
    protected String user = null;
    protected String password = null;
    protected String basicAuth = null;

    public SimpleBeanIfaceStub(URI uri) throws RestException {
        super(uri);
        requestConfig = RequestConfig.custom()
                .setConnectionRequestTimeout(15000)
                .setConnectTimeout(15000)
                .setSocketTimeout(15000)
                .build();
    }
    // Basic Auth.
    public SimpleBeanIfaceStub(URI uri,String user, String password) throws RestException {
        super(uri);
        this.user = user;
        this.password=password;
        requestConfig = RequestConfig.custom()
                .setConnectionRequestTimeout(15000)
                .setConnectTimeout(15000)
                .setSocketTimeout(15000)
                .build();
        try {
            String identity = user + ':' + password;
            byte[] encodedBytes = Base64.encodeBase64(identity.getBytes("UTF-8"));
            this.basicAuth = "Basic " + new String(encodedBytes, "UTF-8");
        }
        catch(UnsupportedEncodingException ex){}
   }
   public SimpleBeanIfaceStub(RestHttpClient client) throws RestException {
        super(client);
        requestConfig = RequestConfig.custom()
                .setConnectionRequestTimeout(15000)
                .setConnectTimeout(15000)
                .setSocketTimeout(15000)
                .build();
    }
    /**
        @Path("simpleBeanTrip")
        @Produces(JSON)
        @Consumes(JSON)
        @POST Simple simpleBeanTrip( @In Simple arg) throwsCaiMonitorException;
     */
    public HttpResponse simpleBeanTrip(Simple arg, List<NameValuePair> params, List<NameValuePair> headers ) throws  SimpleBeanException {
        CloseableHttpResponse response = null;
        try {
            String pathurl = "simpleBeanTrip";
            String uriStr = getHost().toURI()+ "/" + webapp + endpoint;
            URIBuilder builder = new URIBuilder(uriStr + (uriStr.endsWith("/")?"":"/") + pathurl);
            if(params!=null) {
                builder.setParameters(params);
            }
            HttpPost post = new HttpPost(builder.build());
            if(headers!=null) for(NameValuePair pair : headers){ // application headers
                post.setHeader(pair.getName(),pair.getValue());
            }
            this.addHeaders(post); // add additional security headers.
            if(basicAuth!=null) post.setHeader("Authentication", basicAuth);

            // post.setConfig(requestConfig); //timeouts
            /**
             * Body
             */
            String body = SimpleBeanIfaceJsonVisitor.execute(arg);
            post.setEntity(new StringEntity(body, ContentType.APPLICATION_JSON));
            /**
             * Execute
             */
            System.out.println("Executing request " + post.getRequestLine());
            response = ((CloseableHttpClient)client).execute(post);
        }
        catch(UnknownHostException ex) {
            throw new SimpleBeanException("Unknown Host " + this.getHost().getHostName() ,ex) ;
        }
        catch(URISyntaxException ex) {
            throw new SimpleBeanException("simpleBeanTrip() URI Syntax Exception",ex) ;
        }
        catch(IllegalArgumentException ex) {
            throw new SimpleBeanException("simpleBeanTrip() Illegal Argument Exception",ex) ;
        }
        catch(IOException ex) {
            throw new SimpleBeanException("simpleBeanTrip() IO Exception",ex) ;
        }
        catch(RestException ex) {
            throw new SimpleBeanException("simpleBeanTrip() Rest Encode Error",ex) ;
        }
        return response;
    }

    /**
     * Client timeouts.
     */
    public void setTimeouts(int connRequstTimeout, int connTimeout, int socketTimeout) {
        this.requestConfig = requestConfig.copy(this.requestConfig)
                .setConnectionRequestTimeout(connRequstTimeout)
                .setConnectTimeout(connTimeout)
                .setSocketTimeout(socketTimeout)
                .build();
    }
}
