package com.companyname.simplebeans.simplebeaniface.common.beans.abstracts;

import com.companyname.simplebeans.simplebeaniface.common.enums.*;
import com.companyname.simplebeans.common.SimpleBeansThingVisitor;
import com.companyname.simplebeans.simplebeaniface.common.beans.Simple;
import com.objectriver.microservices.things.*;
import com.objectriver.microservices.util.ISO8601DateTimeSingleton;

import java.sql.Timestamp;
import java.sql.Date;
import java.math.BigDecimal;
import java.util.*;

/**
 *                             NOTICE
 *             COPYRIGHT(c) 2016 ObjectRiver, Inc.
 *                UNPUBLISHED - ALL RIGHTS RESERVED
 *
 *      This program is confidential, proprietary, and a trade
 *  secret of ObjectRiver, Inc. The receipt or possession of
 *     this program does not convey any rights to reproduce or
 *      disclose its contents, or to manufacture, use, or sell
 *       anything that it may describe, in whole or in part,
 *  without the specific written consent of ObjectRiver, Inc.
 *
 */
public abstract class Simple__ extends RestObject {
    public static enum Members {myinteger,mytimestamp,mydate,mydouble,mystring,mythings}
    public Simple__(String identifier) {
        super(identifier);
        this.concreteClass=true;
    }
    /**
     * valueOf Simple Factory
     */
    public static Simple valueOf(String identifier, Integer myinteger, Timestamp mytimestamp, Date mydate, Double mydouble, String mystring, MyThings mythings ) {
        Simple bean = new Simple(identifier);
        bean.setMyinteger(myinteger);
        bean.setMytimestamp(mytimestamp);
        bean.setMydate(mydate);
        bean.setMydouble(mydouble);
        bean.setMystring(mystring);
        bean.setMythings(mythings);
        return bean;
    }
    public static Simple valueOf(RestObject obj) {
        Simple bean = new Simple(obj.getIdentifier());
        for(RestMember member : obj.getMembers()) {
            switch(member.getIdentifier().toLowerCase()) {
            case "myinteger": bean.setMyinteger(obj.get("myinteger")); break;
            case "mytimestamp": bean.setMytimestamp(obj.get("mytimestamp")); break;
            case "mydate": bean.setMydate(obj.get("mydate")); break;
            case "mydouble": bean.setMydouble(obj.get("mydouble")); break;
            case "mystring": bean.setMystring(obj.get("mystring")); break;
            case "mythings": bean.setMythings(obj.get("mythings")); break;
            default:
                bean.setValue(member.getIdentifier(), member.getValue());
            }
        }
        return bean;
    }
    /**
     * Properties
     */
    protected Integer    myinteger;
    protected Timestamp    mytimestamp;
    protected Date    mydate;
    protected Double    mydouble;
    protected String    mystring;
    protected MyThings    mythings;

    /**
     * Integer myinteger
     */
    public Integer getMyinteger() { return myinteger; }
    public void setMyinteger(Integer myinteger) { this.myinteger = myinteger; }
    public void setMyinteger(RestMember member) {
        if(member==null) return;
        {
            BigDecimal bigdecimal = (BigDecimal) member.getValue();
            setMyinteger((bigdecimal==null)?null:bigdecimal.intValue());
        }
        this.remove(member.getIdentifier());
    }

    /**
     * Timestamp mytimestamp
     */
    public Timestamp getMytimestamp() { return mytimestamp; }
    public void setMytimestamp(Timestamp mytimestamp) { this.mytimestamp = mytimestamp; }
    public void setMytimestamp(RestMember member) {
        if(member==null) return;
        switch(member.getType()) {
            case Timestamp:
                setMytimestamp((Timestamp) member.getValue());
                break;
            case String:
                try {
                    setMytimestamp((Timestamp)ISO8601DateTimeSingleton.getInstance().parseDateTime(new Timestamp(System.currentTimeMillis()), (String) member.getValue()));
                }
                catch(java.text.ParseException ex){}
                break;
        }
        this.remove(member.getIdentifier());
    }

    /**
     * Date mydate
     */
    public Date getMydate() { return mydate; }
    public void setMydate(Date mydate) { this.mydate = mydate; }
    public void setMydate(RestMember member) {
        if(member==null) return;
        switch(member.getType()) {
        case Date:
            setMydate((Date) member.getValue());
            break;
        case String:
            try {
                setMydate((Date)ISO8601DateTimeSingleton.getInstance().parseDateTime(new Date(System.currentTimeMillis()), (String) member.getValue()));
            }
            catch(java.text.ParseException ex){}
            break;
        }
        this.remove(member.getIdentifier());
    }

    /**
     * Double mydouble
     */
    public Double getMydouble() { return mydouble; }
    public void setMydouble(Double mydouble) { this.mydouble = mydouble; }
    public void setMydouble(RestMember member) {
        if(member==null) return;
        {
            BigDecimal bigdecimal = (BigDecimal) member.getValue();
            setMydouble((bigdecimal==null)?null:bigdecimal.doubleValue());
        }
        this.remove(member.getIdentifier());
    }

    /**
     * String mystring
     */
    public String getMystring() { return mystring; }
    public void setMystring(String mystring) { this.mystring = mystring; }
    public void setMystring(RestMember member) {
        if(member==null) return;
        setMystring((String)member.getValue());
        this.remove(member.getIdentifier());
    }

    /**
     * MyThings mythings
     */
    public MyThings getMythings() { return mythings; }
    public void setMythings(MyThings mythings) { this.mythings = mythings; }
    public void setMythings(RestMember member) {
        if(member==null) return;
        setMythings(MyThings.valueOf((String)member.getValue()));
        this.remove(member.getIdentifier());
    }


    /**
     * Visitor
     */
    public boolean acceptVisit(Visitor visitor, boolean descend) {
        SimpleBeansThingVisitor v = (visitor instanceof SimpleBeansThingVisitor) ? (SimpleBeansThingVisitor)visitor : null;
        if(v!=null) descend = v.beginVisitOfSimple((Simple) this);
        if (descend) { // visit members
            descend &= super.acceptVisit(visitor, descend);
        }
        if(v!=null) v.endVisitOfSimple((Simple) this);
        return descend;
    }

    public List<RestMember> getMembers() {
        /**
         * This is logic to include transient members. returnStatus hack.
         */
        Set<String> superSet = new HashSet<String>();
        List<RestMember> superList = super.getMembers();
        for(RestMember member : superList) {
            superSet.add(member.identifier);
        }
        /** Concrete RestObject class. */
        if(!superSet.contains(Members.myinteger.name()))
            superList.add(new RestMember(Members.myinteger.name(),RestThingType.Integer,myinteger,this));
        if(!superSet.contains(Members.mytimestamp.name()))
            superList.add(new RestMember(Members.mytimestamp.name(),RestThingType.Timestamp,mytimestamp,this));
        if(!superSet.contains(Members.mydate.name()))
            superList.add(new RestMember(Members.mydate.name(),RestThingType.Date,mydate,this));
        if(!superSet.contains(Members.mydouble.name()))
            superList.add(new RestMember(Members.mydouble.name(),RestThingType.Double,mydouble,this));
        if(!superSet.contains(Members.mystring.name()))
            superList.add(new RestMember(Members.mystring.name(),RestThingType.String,mystring,this));
        if(!superSet.contains(Members.mythings.name()))
            superList.add(new RestMember(Members.mythings.name(),RestThingType.Enumeration,mythings,this));
        return superList;
    }
    public void setValue(String key, Object value) {
        try {
            switch (key.toLowerCase()) {
            case "myinteger":
                if(value instanceof BigDecimal) setMyinteger(((BigDecimal)value).intValue());
                else setMyinteger((Integer)value);
                break;
            case "mytimestamp": setMytimestamp((Timestamp) value); break;
            case "mydate": setMydate((Date) value); break;
            case "mydouble":
                if(value instanceof BigDecimal) setMydouble(((BigDecimal)value).doubleValue());
                else setMydouble((Double)value);
                break;
            case "mystring": setMystring((String) value); break;
            case "mythings": setMythings(MyThings.get(value)); break;
            default: super.put(key, value); //transient
            }
        }
        catch(ClassCastException ex) {
            throw new RuntimeException("Type mismatch setting member=" + key + " in bean " + this.getClass().getName());
        }
    }
    public Object getValue(String key) {
        try {
            switch (key.toLowerCase()) {
                case "myinteger": return getMyinteger();
                case "mytimestamp": return getMytimestamp();
                case "mydate": return getMydate();
                case "mydouble": return getMydouble();
                case "mystring": return getMystring();
                case "mythings": return getMythings();
                default:
                    RestMember member = super.get(key); //transient
                    return (member==null) ? null : member.getValue();
            }
        }
        finally {}
    }

}
